package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author louis
 * @date 2023/2/27
 */
@Data
public class BigScreenOrderReq implements Serializable {

    private static final long serialVersionUID = 851147841678248314L;

    private Long bizId;

    /**
     * 部门id
     */
    private String  depId;

    /**
     * userId
     */
    private String userId;

    private List<Long> userIds;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    private PageDto pageDto=new PageDto();

    public void validate() {
        init();
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(startTime != null, "开始时间 不能为空");
        Preconditions.checkArgument(endTime != null, "结束时间不能为空");

    }
    public void init() {
        // 默认每页四条数据
        pageDto.setPageSize(4);
    }


    public QueryOrderListReq convertToOrderListReq() {
        QueryOrderListReq req = new QueryOrderListReq();
        req.setBizId(bizId);
        req.setUserIds(userIds);
        req.setAddTimeStart(startTime);
        req.setAddTimeEnd(endTime);

        return req;
    }


}
