package cn.kinyun.customer.center.enums.electricity;

import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
public enum TaoBaoOrderStatusEnum implements EnumService {

    WAIT_BUYER_PAY(1, "等待买家付款", "等待买家付款", OrderStatusEnum.WAIT_PAY.getValue()),
    WAIT_PRE_AUTH_CONFIRM(2, "余额宝0元购合约中", "余额宝0元购合约中", OrderStatusEnum.WAIT_PAY.getValue()),
    PAY_PENDING(3, "外卡支付付款确认中", "外卡支付付款确认中", OrderStatusEnum.WAIT_PAY.getValue()),
    ALL_WAIT_PAY(4, "所有买家未付款的交易", "所有买家未付款的交易", OrderStatusEnum.WAIT_PAY.getValue()),
    TRADE_NO_CREATE_PAY(5, "没有创建外部交易（支付宝交易）", "没有创建支付宝交易", OrderStatusEnum.WAIT_PAY.getValue()),
    WAIT_SELLER_SEND_GOODS(6, "等待卖家发货", "等待卖家发货,即:买家已付款", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    PAID_FORBID_CONSIGN(7, "该状态代表订单已付款但是处于禁止发货状态", "", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    SELLER_CONSIGNED_PART(8, "卖家部分发货", "卖家部分发货", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    WAIT_BUYER_CONFIRM_GOODS(9, "等待买家确认收货", "等待买家确认收货,即:卖家已发货", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    TRADE_BUYER_SIGNED(10, "买家已签收（货到付款专用）", "买家已签收（货到付款专用）", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_FINISHED(11, "交易成功", "交易成功", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_CLOSED(12, "交易关闭", "付款以后用户退款成功，交易自动关闭", OrderStatusEnum.CLOSED.getValue()),
    TRADE_CLOSED_BY_TAOBAO(13, "交易被淘宝关闭", "付款以前，卖家或买家主动关闭交易", OrderStatusEnum.CLOSED.getValue()),
    ALL_CLOSED(14, "所有关闭的交易", "所有关闭的交易", OrderStatusEnum.CLOSED.getValue());

    TaoBaoOrderStatusEnum(int id, String name, String desc, int orderStatus) {
        this.id = id;
        this.name = name;
        this.desc = desc;

        this.orderStatus = orderStatus;
    }

    private final int id;
    private final String name;
    private final String desc;
    private final int orderStatus;

    /**
     * 是否收费
     */

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }


    private static final Map<Integer, TaoBaoOrderStatusEnum> CACHE;

    private static final Map<Integer, List<Integer>> statusCache;

    static {
        CACHE = new HashMap<>(3);
        for (TaoBaoOrderStatusEnum item : TaoBaoOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<>();
        for (TaoBaoOrderStatusEnum item : TaoBaoOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }

    public static List<Integer> getTaoBaoOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static TaoBaoOrderStatusEnum getByEnumName(String enumName) {
        TaoBaoOrderStatusEnum[] values = TaoBaoOrderStatusEnum.values();

        for (TaoBaoOrderStatusEnum value : values) {
            if (StringUtils.equals(value.name(), enumName)) {
                return value;
            }
        }
        return null;
    }

    public static TaoBaoOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }
}
