package cn.kinyun.customer.center.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zyl
 * <p>
 * 退转状态
 */
@Getter
public enum RefundStatusEnum {
    /**
     * 正常
     */
    NONE(1, "正常"),
    TRANSFERRING(2, "转课中"),
    TRANSFERRED(3, "已转课"),
    REFUNDING(4, "退费中"),
    REFUNDED(5, "已退费"),
    FAIL(6, "已失败"),
    REFUSE(7, "拒绝退款");


    private int value;
    private String desc;

    RefundStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, RefundStatusEnum> cache;

    static {
        cache = new HashMap<>();
        for (RefundStatusEnum item : RefundStatusEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static RefundStatusEnum get(int value) {
        return cache.get(value);
    }
}
