/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum YzOrderStatusEnum implements EnumService
{
    WAIT_BUYER_PAY(1, "\u7b49\u5f85\u4e70\u5bb6\u4ed8\u6b3e\uff0c\u5b9a\u91d1\u9884\u552e\u63cf\u8ff0\uff1a\u5b9a\u91d1\u5f85\u4ed8\u3001\u7b49\u5f85\u5c3e\u6b3e\u652f\u4ed8\u5f00\u59cb\u3001\u5c3e\u6b3e\u5f85\u4ed8", OrderStatusEnum.WAIT_PAY.getValue()),
    TRADE_PAID(2, "\u8ba2\u5355\u5df2\u652f\u4ed8", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_CONFIRM(3, "\u5f85\u786e\u8ba4\uff0c\u5305\u542b\u5f85\u6210\u56e2\u3001\u5f85\u63a5\u5355\u7b49\u7b49\u3002\u5373\uff1a\u4e70\u5bb6\u5df2\u4ed8\u6b3e\uff0c\u7b49\u5f85\u6210\u56e2\u6216\u7b49\u5f85\u63a5\u5355", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_SELLER_SEND_GOODS(4, "\u7b49\u5f85\u5356\u5bb6\u53d1\u8d27\uff0c\u5373\uff1a\u4e70\u5bb6\u5df2\u4ed8\u6b3e", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    WAIT_BUYER_CONFIRM_GOODS(5, "\u7b49\u5f85\u4e70\u5bb6\u786e\u8ba4\u6536\u8d27\uff0c\u5373\uff1a\u5356\u5bb6\u5df2\u53d1\u8d27", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    TRADE_SUCCESS(6, "\u4e70\u5bb6\u5df2\u7b7e\u6536\u4ee5\u53ca\u8ba2\u5355\u6210\u529f", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_CLOSED(7, "\u4ea4\u6613\u5173\u95ed", OrderStatusEnum.CLOSED.getValue());

    private final int id;
    private final String desc;
    private final int orderStatus;
    private static final Map<Integer, YzOrderStatusEnum> CACHE;
    private static final Map<Integer, List<Integer>> statusCache;

    private YzOrderStatusEnum(int id, String desc, int orderStatus) {
        this.id = id;
        this.desc = desc;
        this.orderStatus = orderStatus;
    }

    public int getValue() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public static List<Integer> getYzOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static YzOrderStatusEnum getByEnumName(String enumName) {
        YzOrderStatusEnum[] values;
        for (YzOrderStatusEnum value : values = YzOrderStatusEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.name(), (CharSequence)enumName)) continue;
            return value;
        }
        return null;
    }

    public static YzOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }

    static {
        CACHE = new HashMap<Integer, YzOrderStatusEnum>(3);
        for (YzOrderStatusEnum item : YzOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<Integer, List<Integer>>();
        for (YzOrderStatusEnum item : YzOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }
}

