/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum PayChannelType {
    UNKNOW(0, "\u73b0\u91d1\u652f\u4ed8", "cash"),
    WEIXIN_NATIVE(1, "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8", "weixin"),
    WEIXIN_APP(2, "\u5fae\u4fe1APP\u652f\u4ed8", "weixin"),
    WEIXIN_H5(3, "\u5fae\u4fe1\u624b\u673a\u7f51\u7ad9\u652f\u4ed8", "weixin"),
    WEIXIN_JSAPI(4, "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8", "weixin"),
    WEIXIN_WEAPPLET(5, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8", "weixin"),
    WEIXIN_PRE_CREATE(6, "\u5fae\u4fe1\u5f53\u9762\u4ed8", "weixin"),
    ALIPAY_PRE_CREATE(7, "\u652f\u4ed8\u5b9d\u5f53\u9762\u4ed8-\u626b\u7801\u652f\u4ed8", "alipay"),
    ALIPAY_APP(8, "\u652f\u4ed8\u5b9dAPP\u652f\u4ed8", "alipay"),
    ALIPAY_WAP(9, "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8", "alipay"),
    ALIPAY_PAGE(10, "\u652f\u4ed8\u5b9d\u7535\u8111\u7f51\u7ad9\u652f\u4ed8", "alipay"),
    BANKCARD(11, "\u94f6\u884c\u5361\u652f\u4ed8", "bankcard"),
    PREPAIDCARD(12, "\u50a8\u503c\u5361\u652f\u4ed8", "prepaidcard"),
    GIFT_CARD(13, "\u793c\u54c1\u5361\u652f\u4ed8", "giftcard"),
    OTHER(99, "\u5176\u4ed6", "other");

    static Map<Integer, PayChannelType> MAP;
    private Integer value;
    private String desc;
    private String serviceCode;

    private PayChannelType(Integer value, String desc, String serviceCode) {
        this.value = value;
        this.desc = desc;
        this.serviceCode = serviceCode;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public static PayChannelType get(Integer value) {
        return MAP.get(value);
    }

    public static PayChannelType getByDesc(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return null;
        }
        for (PayChannelType payChannelType : PayChannelType.values()) {
            String de = payChannelType.getDesc();
            if (!StringUtils.equals((CharSequence)de, (CharSequence)desc)) continue;
            return payChannelType;
        }
        return null;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(PayChannelType.values()).collect(Collectors.toMap(PayChannelType::getValue, e -> e)));
    }
}

