package cn.kinyun.customer.center.service;


import cn.kinyun.customer.center.dto.req.RefundOrderReq;
import cn.kinyun.customer.center.dto.resp.RefundOrderResp;

import java.util.List;

public interface CcCustomerRefundOrderService {
    String refundOrder(Long bizId, Long userId, RefundOrderReq req);

    void updateRefundOrder(Long bizId, Long userId, RefundOrderReq req);


    /**
     * 查询正在退款中退款单根据订单编号
     *
     * @param bizId
     * @param orderNo
     * @return
     */
    String queryRefundByOrderNo(Long bizId, String orderNo);

    List<RefundOrderResp> queryRefundOrder(Long bizId, String orderNo, String refundOrderNum);

    void transfer(Long bizId, Long userId, RefundOrderReq req);

    /**
     * 更新审批状态
     * @param spNo
     * @param spStatus
     */
    void updateRefundOrderSpStatus(String spNo, Integer spStatus);

    /**
     * 更新退款状态
     * @param spNo
     * @param refundStatus
     */
    void updateRefundOrderStatus(String spNo, Integer refundStatus);
}
