package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 * @Description 有赞交易消息类型枚举类
 */
public enum YzTradeMsgTypeEnum implements EnumService {

    TRADE_TRADE_CREATE(1, "trade_TradeCreate", "交易创建", 1),
    TRADE_TRADE_MEMO_MODIFIED(2, "trade_TradeMemoModified", "卖家修改交易备注", 1),
    TRADE_TRADE_SELLER_SHIP(3, "trade_TradeSellerShip", "卖家发货", 1),
    TRADE_TRADE_SUCCESS(4, "trade_TradeSuccess", "交易成功", 1),
    TRADE_TRADE_CLOSE(5, "trade_TradeClose", "交易关闭", 1),
    TRADE_MESSAGES_THE_CHANGE_ADDRESSES(6, "trade_MessagesTheChangeAddresses", "卖家修改买家收货地址消息", 1),
    YOUZAN_TRADE_MESSAGES_THE_CHANGE_ADDRESSES_BY_BUYER(7, "youzan_trade_MessagesTheChangeAddressesByBuyer", "买家自助修改收货地址", 0),
    TRADE_TRADE_BUYER_PAY(8, "trade_TradeBuyerPay", "买家付款(即商家待发货)", 1),
    TRADE_TRADE_PAID(9, "trade_TradePaid", "交易支付", 1),
    TRADE_TRADE_PARTLY_SELLER_SHIP(10, "trade_TradePartlySellerShip", "卖家部分发货", 1);

    private final int id;
    private final String type;
    private final String desc;
    // 是否收费
    private final Integer charge;

    YzTradeMsgTypeEnum(int id, String type, String desc, Integer charge) {
        this.id = id;
        this.type = type;
        this.desc = desc;
        this.charge = charge;
    }

    @Override
    public int getValue() {
        return id;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCharge() {
        return charge;
    }

    private static final Map<String, YzTradeMsgTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzTradeMsgTypeEnum item : YzTradeMsgTypeEnum.values()) {
            CACHE.put(item.getType(), item);
        }
    }

    public static YzTradeMsgTypeEnum get(String type) {
        return CACHE.get(type);
    }
}