package cn.kinyun.customer.center.enums.electricity;

import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author louis
 * @date 2022/9/22
 */
public enum YzOrderStatusEnum implements EnumService {

    WAIT_BUYER_PAY(1, "等待买家付款，定金预售描述：定金待付、等待尾款支付开始、尾款待付", OrderStatusEnum.WAIT_PAY.getValue()),
    TRADE_PAID(2, "订单已支付", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_CONFIRM(3, "待确认，包含待成团、待接单等等。即：买家已付款，等待成团或等待接单", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_SELLER_SEND_GOODS(4, "等待卖家发货，即：买家已付款", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    WAIT_BUYER_CONFIRM_GOODS(5, "等待买家确认收货，即：卖家已发货", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    TRADE_SUCCESS(6, "买家已签收以及订单成功", OrderStatusEnum.SUCCESSED.getValue()),
    TRADE_CLOSED(7, "交易关闭", OrderStatusEnum.CLOSED.getValue());

    YzOrderStatusEnum(int id, String name, int orderStatus) {
        this.id = id;
        this.name = name;
        this.orderStatus = orderStatus;
    }

    private final int id;
    private final String name;
    private final int orderStatus;

    /**
     * 是否收费
     */

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    private static final Map<Integer, YzOrderStatusEnum> CACHE;

    private static final Map<Integer, List<Integer>> statusCache;

    static {
        CACHE = new HashMap<>(3);
        for (YzOrderStatusEnum item : YzOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<>();
        for (YzOrderStatusEnum item : YzOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }

    public static List<Integer> getYzOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static YzOrderStatusEnum getByEnumName(String enumName) {
        YzOrderStatusEnum[] values = YzOrderStatusEnum.values();

        for (YzOrderStatusEnum value : values) {
            if (StringUtils.equals(value.name(), enumName)) {
                return value;
            }
        }
        return null;
    }

    public static YzOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }
}
