package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 */
public enum PlatformEnum implements EnumService {

    YOU_ZAN(1, "有赞"),
    TAO_BAO(2, "淘宝"),
    DOU_DIAN(3, "抖店"),
    HAI_TUN(4, "海豚知道"),
    WEICHAT_MINA_SHOP(5, "微信小商店");

    private final int id;
    private final String name;

    PlatformEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, PlatformEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (PlatformEnum item : PlatformEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static PlatformEnum get(int id) {
        return CACHE.get(id);
    }
}