package cn.kinyun.customer.center.dto.resp;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * author: jw
 * date: 2022/4/19 下午4:13
 * content:
 */
@Data
@ToString(callSuper = true)
public class OrderListResp implements Serializable {

    private String phone;
    private String crmCustomerName;
    private String customerNum;
    private String leadsNum;
    private String productLineNum;

    private String id;

    //订单信息
    private String orderNo;  //订单编号

    private Date orderTime;   //下单时间

    private String source;    //来源

    private String sourceDesc;

    private List<String> skuNames;  //商品名

    private List<OrderSkuResp> skuList;  //商品名

    //付款信息
    //价格金额都是放大一万倍
    private Long orderAmount;   //订单金额

    private Long discountAmount;  //优惠券金额

    private Long paidAmount;    //付款金额

    private Date payTime;

    private Long refundAmount;

    private Integer paidChannelType;      //支付方式

    private String paidTypeDesc;   //支付方式描述

    private Integer status;

    private String statusDesc;

    /**
     * 详情页用的订单状态
     */
    private String orderStatusDesc;

    /**
     * 详情页用的订单状态
     */
    private Integer orderStatus;

    private String payNo;   //支付流水号

    private List<OrderPayRecordResp> payRecordList;   //支付信息

    private List<RefundOrderListResp> refundOrderList;   //退款信息

    private String paymentVoucherUrl;  //支付凭证url

    private List<String> paymentVoucherUrlList;  //支付凭证url

    //客户信息
    private String customerName;    //客户名

    private String customerMobile;  //客户手机号

    private Long userId;     //成单人id

    //归属信息
    private String userName;  //成单人名

    private Long achieveDepartId;  //业绩归属部门id

    private String achieveDepartDesc;   //归属部门描述

    private List<ExtendFieldResp> extendFiled;   //业务扩展字段

    //订单录入信息
    private String entryUser;  //录入人

    private Date entryTime;    // 录入时间

    private String remark;

    private Integer isEntry;            //是否是手动录入订单, 1 手动录入

    /**
     * 订单应付金额
     */
    private Long shouldPayAmount;

    /**
     * 配送地址
     */
    private String deliveryAddress;

    private String receiveName;

    private String receiveTel;

    private List<LogisticsResp> logisticsList;   //物流信息

    private Boolean canBeDecode = Boolean.FALSE;

}
