package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.exception.BusinessException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;


@Data
public class RefundOrderReq implements Serializable {
    private String refundOrderNum;

    private String refundNo;

    private String customerNum;

    private String mobile;

    private String orderNo;

    private Long refundAmount;

    private Long orderAmount;

    private Integer usePeriod;

    private Long periodPrice;

    private Long otherAmount;

    private Integer refundType;   //1 原路退回  2 银行转账

    private String accountName;

    private String cardNumber;

    private String bank;   //开户银行

    private String transferNo;  //转账流水号

    private List<String> transferAttachments;  //转转附件

    private String reason;

    private List<String> attachments;

    private String remark;

    private String spNo;

    private String applicant;   //审批申请人


    public void validate() {
        if (StringUtils.isAllEmpty(customerNum, mobile)) {
            throw new BusinessException(CommonErrorCode.PARAM_ERROR, "客户不能为空");
        }
        Preconditions.checkArgument(StringUtils.isNotEmpty(orderNo), "订单编号不能为空");
        Preconditions.checkArgument(refundAmount != null, "退款金额不能为空");

        Preconditions.checkArgument(refundType != null, "退款方式不能为空");
        Preconditions.checkArgument(refundType == 1 || refundType == 2, "退款方式不对");

        Preconditions.checkArgument(StringUtils.isNotEmpty(reason), "退款原因不能为空");
    }
}
