/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.order.service.impl;

import cn.kinyun.crm.common.dto.msg.TradeOrderMsg;
import cn.kinyun.crm.common.enums.OrderSource;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.config.mapper.ProductLineMapper;
import cn.kinyun.crm.dal.customer.mapper.CustomerLibMapper;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderMapper;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderTradeLogMapper;
import cn.kinyun.crm.dal.util.BizTableContext;
import cn.kinyun.crm.sal.order.service.CustomerOrderService;
import cn.kinyun.crm.sal.order.service.TradeOrderService;
import cn.kinyun.crm.sal.order.service.dto.req.OrderAddReq;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.service.ScrmUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TradeOrderServiceImpl
implements TradeOrderService {
    private static final Logger log = LoggerFactory.getLogger(TradeOrderServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ProductLineMapper productLineMapper;
    @Autowired
    private CustomerLibMapper customerLibMapper;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private CustomerOrderTradeLogMapper customerOrderTradeLogMapper;
    @Autowired
    private CustomerOrderService customerOrderService;
    @Autowired
    private ScrmUserService scrmUserService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onReceive(TradeOrderMsg params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        OrderAddReq req = new OrderAddReq();
        BeanUtils.copyProperties((Object)params, (Object)req);
        req.setSource(OrderSource.TRADE_ORDER.getValue());
        req.validate();
        BizTableContext.putBizId((Long)params.getBizId());
        this.customerOrderService.add(req);
    }
}

