/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.order.service.impl;

import cn.kinyun.crm.common.dto.conf.OrderAmountConf;
import cn.kinyun.crm.common.enums.OrderTradeType;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.customer.entity.CustomerLib;
import cn.kinyun.crm.dal.customer.mapper.CustomerLibMapper;
import cn.kinyun.crm.dal.dto.CustomerAndOrderStatic;
import cn.kinyun.crm.dal.leads.entity.LeadsBindingInfo;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.leads.mapper.LeadsBindingInfoMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import cn.kinyun.crm.dal.order.entity.CustomerOrder;
import cn.kinyun.crm.dal.order.entity.CustomerOrderTradeLog;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderMapper;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderTradeLogMapper;
import cn.kinyun.crm.sal.conf.service.SysConfigService;
import cn.kinyun.crm.sal.follow.service.CustomerTrendService;
import cn.kinyun.crm.sal.leads.service.LeadsStageService;
import cn.kinyun.crm.sal.order.service.CustomerOrderService;
import cn.kinyun.crm.sal.order.service.dto.req.CustomerOrderListReq;
import cn.kinyun.crm.sal.order.service.dto.req.OrderAddReq;
import cn.kinyun.crm.sal.order.service.dto.req.OrderListReq;
import cn.kinyun.crm.sal.order.service.dto.resp.OrderListResp;
import cn.kinyun.crm.sal.transfer.service.TransferService;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.ScrmStageService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.StageDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerOrderServiceImpl
implements CustomerOrderService {
    private static final Logger log = LoggerFactory.getLogger(CustomerOrderServiceImpl.class);
    private static final int HEADER_ROWS = 1;
    private static final int MAX_ROWS = 5000;
    private static final String HEADER_FIRST_CELL_STR = "\u6210\u5355\u9500\u552e\u624b\u673a\u53f7";
    private static final String HEADER_SECOND_CELL_STR = "\u6ce8\u518c\u7528\u6237\u6635\u79f0";
    private static final String HEADER_THIRD_CELL_STR = "\u6ce8\u518c\u7528\u6237\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_FOUR_CELL_STR = "\u5546\u54c1\u7f16\u53f7";
    private static final String HEADER_FIVE_CELL_STR = "\u5546\u54c1\u540d\u79f0";
    private static final String HEADER_SIX_CELL_STR = "\u8ba2\u5355\u7f16\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_SEVEN_CELL_STR = "\u8ba2\u5355\u91d1\u989d\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_EIGHT_CELL_STR = "\u4ea4\u6613\u7f16\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_NINE_CELL_STR = "\u4e0b\u5355\u65f6\u95f4";
    private static final String IMPORT_FILE_DIR = "./importDir/crm";
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private CustomerOrderTradeLogMapper customerOrderTradeLogMapper;
    @Autowired
    private CustomerLibMapper customerLibMapper;
    @Autowired
    private LeadsLibMapper leadsLibMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private LeadsBindingInfoMapper leadsBindingInfoMapper;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private TransferService transferService;
    @Autowired
    private CustomerTrendService customerTrendService;
    @Autowired
    private ScrmStageService scrmStageService;
    @Autowired
    private LeadsStageService leadsStageService;

    @Override
    public List<OrderListResp> list(OrderListReq params) {
        log.info("query customer order list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getLeadsNum()), (Object)"leadsNum is null");
        Long bizId = LoginUtils.getCurrentUserBizId();
        LeadsLib leadsLib = this.leadsLibMapper.getByNum(bizId, params.getLeadsNum());
        Preconditions.checkArgument((leadsLib != null ? 1 : 0) != 0, (Object)"\u7ebf\u7d22\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Long customerId = leadsLib.getCustomerId();
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize());
        }
        Page list = this.customerOrderMapper.selectByCustomerId(bizId, customerId);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf((int)list.getTotal()));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("Customer order not found, bizId={}, customerId={}", (Object)bizId, (Object)customerId);
            return Collections.emptyList();
        }
        HashSet userIds = Sets.newHashSet();
        for (CustomerOrder it : list) {
            if (it.getUserId() != null && it.getUserId() > 0L) {
                userIds.add(it.getUserId());
            }
            if (it.getCreateBy() == null || it.getCreateBy() <= 0L) continue;
            userIds.add(it.getCreateBy());
        }
        Map userNames = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            userNames = this.scrmUserService.getNameByIds((Collection)userIds);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (CustomerOrder it : list) {
            OrderListResp dto = new OrderListResp();
            result.add(dto);
            dto.setOrderNo(it.getOrderNo());
            dto.setOrderTime(it.getOrderTime());
            dto.setSkuNo(it.getSkuNo());
            dto.setSkuName(it.getSkuName());
            dto.setOrderPrice(it.getOrderPrice());
            dto.setPaidAmount(it.getPaidAmount());
            dto.setRefundAmount(it.getRefundAmount());
            dto.setRefundTime(it.getRefundTime());
            dto.setUserName((String)userNames.get(it.getUserId()));
            dto.setCreatorName((String)userNames.get(it.getCreateBy()));
        }
        return result;
    }

    @Override
    public List<OrderListResp> list(CustomerOrderListReq param) {
        log.info("query order list, params={}, operatorId={}", (Object)param, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((param.getPageDto() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u4fe1\u606f\u4e0d\u5b58\u5728");
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        List orderList = this.customerOrderMapper.selectCustomerOrderList(bizId, userId, param.getSkuName(), param.getCustomerName(), param.getOrderTimeBegin(), param.getOrderTimeEnd(), param.getPageDto().getPageSize(), param.getPageDto().getPageNum());
        param.getPageDto().setCurPageCount(Integer.valueOf(orderList.size()));
        param.getPageDto().setCount(Integer.valueOf(this.customerOrderMapper.countCustomerOrderList(bizId, userId, param.getSkuName(), param.getCustomerName(), param.getOrderTimeBegin(), param.getOrderTimeEnd())));
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return Lists.newArrayList();
        }
        HashSet userIds = Sets.newHashSet();
        HashSet customerIds = Sets.newHashSet();
        for (CustomerOrder it2 : orderList) {
            if (it2.getUserId() != null && it2.getUserId() > 0L) {
                userIds.add(it2.getUserId());
            }
            if (it2.getCreateBy() != null && it2.getCreateBy() > 0L) {
                userIds.add(it2.getCreateBy());
            }
            customerIds.add(it2.getCustomerId());
        }
        Map userNames = this.scrmUserService.getNameByIds((Collection)userIds);
        Map<Long, String> customerNames = this.customerLibMapper.getByIds(bizId, (Collection)customerIds).stream().filter(it -> it.getName() != null).collect(Collectors.toMap(CustomerLib::getId, CustomerLib::getName));
        ArrayList result = Lists.newArrayListWithCapacity((int)orderList.size());
        for (CustomerOrder it3 : orderList) {
            OrderListResp dto = new OrderListResp();
            result.add(dto);
            dto.setOrderNo(it3.getOrderNo());
            dto.setOrderTime(it3.getOrderTime());
            dto.setSkuNo(it3.getSkuNo());
            dto.setSkuName(it3.getSkuName());
            dto.setOrderPrice(it3.getOrderPrice());
            dto.setPaidAmount(it3.getPaidAmount());
            dto.setRefundAmount(it3.getRefundAmount());
            dto.setRefundTime(it3.getRefundTime());
            dto.setUserName((String)userNames.get(it3.getUserId()));
            dto.setCreatorName((String)userNames.get(it3.getCreateBy()));
            dto.setCustomerName(customerNames.get(it3.getCustomerId()));
        }
        return result;
    }

    @Override
    public CustomerAndOrderStatic countCustomerAndOrder() {
        return this.customerOrderMapper.countCustomerAndOrder(LoginUtils.getCurrentUserBizId(), LoginUtils.getCurrentUserId(), null, null, null, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(OrderAddReq params) {
        log.info("add customer order, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        params.validate();
        Long bizId = params.getBizId();
        String mobile = params.getMobile();
        CustomerOrderTradeLog exist = this.customerOrderTradeLogMapper.getByTradeNo(bizId, params.getOrderNo(), params.getTradeNo());
        if (exist != null) {
            log.warn("\u6b64\u4ea4\u6613\u8bb0\u5f55\u5df2\u7ecf\u5904\u7406\u8fc7, \u4e0d\u518d\u91cd\u590d\u5904\u7406\u3002bizId={}, orderNo={}, tradeNo={}", new Object[]{bizId, params.getOrderNo(), params.getTradeNo()});
            throw new IllegalArgumentException(String.format("\u76f8\u540c\u7684\u8ba2\u5355\u4ea4\u6613\u8bb0\u5f55\u7684\u5df2\u7ecf\u5904\u7406\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u5904\u7406: orderNo=%s, tradeNo=%s", params.getOrderNo(), params.getTradeNo()));
        }
        CustomerLib customerLib = this.customerLibMapper.selectByMobile(bizId, mobile);
        if (customerLib == null) {
            log.warn("customer not found, bizId={}, mobile={}", (Object)bizId, (Object)mobile);
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u6b64\u5ba2\u6237: " + mobile);
        }
        Long customerId = customerLib.getId();
        CustomerOrder order = this.customerOrderMapper.getByOrderNo(params.getBizId(), params.getOrderNo());
        if (order == null) {
            order = this.newCustomerOrder(customerId, params);
            this.customerOrderMapper.insert((Object)order);
        }
        CustomerOrderTradeLog tradeLog = this.newCustomerOrderTradeLog(customerId, params);
        this.customerOrderTradeLogMapper.insert((Object)tradeLog);
        this.updateTradeAmount(order, params);
        if (params.getTradeType().intValue() == OrderTradeType.PAID.getValue()) {
            this.refresh(order);
        }
    }

    private void updateTradeAmount(CustomerOrder order, OrderAddReq params) {
        Long amount = this.customerOrderTradeLogMapper.sumTradeAmount(order.getBizId(), order.getOrderNo(), params.getTradeType());
        if (amount == null) {
            amount = 0L;
            log.warn("customer order trade amount is null!! bizId={}, orderNo={}, tradeNo={}, tradeType={}", new Object[]{order.getBizId(), order.getOrderNo(), params.getTradeNo(), params.getTradeType()});
        }
        OrderTradeType tradeType = OrderTradeType.getType((Integer)params.getTradeType());
        switch (tradeType) {
            case PAID: {
                log.info("update paid amount, bizId={}, orderNo={}, {} -> {}", new Object[]{order.getBizId(), order.getOrderNo(), order.getPaidAmount(), amount});
                order.setPaidAmount(amount);
                break;
            }
            case REFUND: {
                log.info("update refund amount, bizId={}, orderNo={}, {} -> {}", new Object[]{order.getBizId(), order.getOrderNo(), order.getRefundAmount(), amount});
                order.setRefundAmount(amount);
                order.setRefundTime(CustomerOrderServiceImpl.newDate(params.getTradeTime()));
            }
        }
        order.setUpdateBy(params.getUserId());
        order.setUpdateTime(new Date());
        this.customerOrderMapper.updateById((Object)order);
    }

    private CustomerOrder newCustomerOrder(Long customerId, OrderAddReq params) {
        Date now = new Date();
        CustomerOrder record = new CustomerOrder();
        record.setNum(this.idGen.getNum());
        record.setSource(params.getSource());
        record.setBizId(params.getBizId());
        record.setCorpId(params.getCorpId());
        record.setUserId(params.getUserId());
        record.setMobile(params.getMobile());
        record.setCustomerId(customerId);
        record.setOrderNo(params.getOrderNo());
        record.setOrderPrice(params.getOrderPrice());
        record.setOrderTime(CustomerOrderServiceImpl.newDate(params.getOrderTime()));
        record.setOrderRemark(params.getOrderRemark());
        record.setSkuNo(params.getSkuNo());
        record.setSkuName(params.getSkuName());
        record.setPaidAmount(Long.valueOf(0L));
        record.setRefundAmount(Long.valueOf(0L));
        if (params.getOrderCreatorId() != null) {
            record.setCreateBy(params.getOrderCreatorId());
        } else {
            record.setCreateBy(params.getUserId());
        }
        record.setCreateTime(now);
        record.setUpdateBy(params.getUserId());
        record.setUpdateTime(now);
        return record;
    }

    private void modCustomerOrder(CustomerOrder record, OrderAddReq params) {
        boolean isChanged = false;
        if (params.getOrderPrice() != null && !Objects.equals(params.getOrderPrice(), record.getOrderPrice())) {
            record.setOrderPrice(params.getOrderPrice());
            isChanged = true;
        }
        if (params.getOrderTime() != null && !Objects.equals(CustomerOrderServiceImpl.newDate(params.getOrderTime()), record.getOrderTime())) {
            record.setOrderTime(CustomerOrderServiceImpl.newDate(params.getOrderTime()));
            isChanged = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getOrderRemark()) && !Objects.equals(params.getOrderRemark(), record.getOrderRemark())) {
            record.setOrderRemark(params.getOrderRemark());
            isChanged = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSkuNo()) && !Objects.equals(params.getSkuNo(), record.getSkuNo())) {
            record.setSkuNo(params.getSkuNo());
            isChanged = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSkuName()) && !Objects.equals(params.getSkuName(), record.getSkuName())) {
            record.setSkuName(params.getSkuName());
            isChanged = true;
        }
        if (isChanged) {
            log.info("update customer order:{}", (Object)record);
            record.setUpdateTime(new Date());
            this.customerOrderMapper.updateById((Object)record);
        }
    }

    private CustomerOrderTradeLog newCustomerOrderTradeLog(Long customerId, OrderAddReq params) {
        Date now = new Date();
        CustomerOrderTradeLog record = new CustomerOrderTradeLog();
        record.setNum(this.idGen.getNum());
        record.setBizId(params.getBizId());
        record.setCorpId(params.getCorpId());
        record.setUserId(params.getUserId());
        record.setCustomerId(customerId);
        record.setOrderNo(params.getOrderNo());
        record.setTradeNo(params.getTradeNo());
        record.setTradeChannel(params.getTradeChannel());
        record.setTradeType(params.getTradeType());
        record.setTradeAmount(params.getTradeAmount());
        record.setTradeTime(CustomerOrderServiceImpl.newDate(params.getTradeTime()));
        record.setTradeRemark(params.getTradeRemark());
        record.setCreateBy(params.getUserId());
        record.setCreateTime(now);
        record.setUpdateBy(params.getUserId());
        record.setUpdateTime(now);
        return record;
    }

    private static Date newDate(Long timestamp) {
        if (timestamp != null && timestamp > 0L) {
            return new Date(timestamp);
        }
        return new Date();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refresh(CustomerOrder order) {
        Long bizId = order.getBizId();
        Long userId = order.getUserId();
        Long productLineId = order.getProductLineId();
        Long customerId = order.getCustomerId();
        if (userId == null || userId <= 0L) {
            log.info("\u6b64\u8ba2\u5355\u6ca1\u6709\u7ed1\u5b9a\u4eba\uff0c\u4e0d\u6267\u884c\u540e\u7eed\u64cd\u4f5c\u3002bizId={}, orderNo={}", (Object)bizId, (Object)order.getOrderNo());
            return;
        }
        List bindings = this.leadsBindingInfoMapper.queryCustomerBindings(bizId, customerId, userId, productLineId, null);
        if (CollectionUtils.isEmpty((Collection)bindings)) {
            log.info("Leads binding info not found. bizId={}, customerId={}, userId={}, productLineId={}", new Object[]{bizId, customerId, userId, productLineId});
            return;
        }
        Set leadsIds = bindings.stream().map(LeadsBindingInfo::getLeadsId).collect(Collectors.toSet());
        List leadsLibs = this.leadsLibMapper.getByIds(bizId, leadsIds);
        Long amount = order.getPaidAmount();
        if (!this.validOrderAmount(bizId, amount)) {
            log.info("\u8ba2\u5355\u6536\u6b3e\u91d1\u989d\u4e0d\u8db3\u4ee5\u5237\u65b0\u7ebf\u7d22\u7ed1\u5b9a\u4fe1\u606f. bizId={}, customerId={}, orderNo={}", new Object[]{bizId, customerId, order.getOrderNo()});
            return;
        }
        StageDto stageDto = this.scrmStageService.getLastStage(bizId);
        if (stageDto != null) {
            this.updateLeadsBindingStage(bizId, userId, stageDto, bindings);
            this.updateLeadsStage(bizId, userId, stageDto, leadsLibs);
        } else {
            log.warn("\u672a\u627e\u5230\u5546\u6237\u914d\u7f6e\u7684\u9636\u6bb5\u4fe1\u606f, bizId={}", (Object)bizId);
        }
        for (LeadsBindingInfo it : bindings) {
            log.info("\u66f4\u65b0\u6210\u4ea4\u5e93, bizId={}, bindingId={}, leadsId={}", new Object[]{bizId, it.getId(), it.getLeadsId()});
            this.transferService.toContract(it);
        }
    }

    @Override
    public void importExcel(Long bizId, InputStream in) {
        FileOutputStream outputStream = null;
        try {
            Workbook workbook;
            try {
                workbook = WorkbookFactory.create((InputStream)in);
            }
            catch (Exception e) {
                log.error("Excel\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "Excel\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String fileName = "./importDir/crm/" + simpleDateFormat.format(new Date()) + "_\u5ba2\u6237\u5bfc\u5165\u7ed3\u679c.xlsx";
            File file = new File(fileName);
            outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    private boolean validOrderAmount(Long bizId, Long amount) {
        OrderAmountConf conf = this.sysConfigService.getOrderAmountConf(bizId);
        if (conf == null) {
            log.warn("\u672a\u627e\u5230\u3010\u5df2\u6210\u5355\u9636\u6bb5\u5237\u65b0\u8bbe\u7f6e\u3011, bizId={}", (Object)bizId);
            return true;
        }
        if (conf.getIsOpen() == null || conf.getIsOpen() == 0) {
            log.info("\u672a\u5f00\u542f\u3010\u5df2\u6210\u5355\u9636\u6bb5\u5237\u65b0\u8bbe\u7f6e\u3011\uff0c\u65e0\u9700\u5224\u65ad\u8ba2\u5355\u6536\u6b3e\u91d1\u989d\u3002");
            return true;
        }
        if (conf.getOrderFlushAmount() == null || conf.getOrderFlushAmount() < 0L) {
            log.info("\u3010\u5df2\u6210\u5355\u9636\u6bb5\u5237\u65b0\u8bbe\u7f6e\u3011\u5237\u65b0\u8ba2\u5355\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u65e0\u9700\u5224\u65ad\u8ba2\u5355\u6536\u6b3e\u91d1\u989d\u3002");
            return true;
        }
        if (amount >= conf.getOrderFlushAmount() * 10000L) {
            log.info("\u8ba2\u5355\u6536\u6b3e\u91d1\u989d\u8fbe\u5230\u5237\u65b0\u91d1\u989d\uff0c\u5373\u5c06\u6267\u884c\u5237\u65b0\u7ebf\u7d22\u64cd\u4f5c\u3002flushAmount={}, paidAmount={}", (Object)conf.getOrderFlushAmount(), (Object)amount);
            return true;
        }
        log.info("\u8ba2\u5355\u6536\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5237\u65b0\u91d1\u989d\uff0c\u4e0d\u5237\u65b0\u7ebf\u7d22\u64cd\u4f5c\u3002flushAmount={}, paidAmount={}", (Object)conf.getOrderFlushAmount(), (Object)amount);
        return false;
    }

    private void updateLeadsBindingStage(Long bizId, Long userId, StageDto stageDto, List<LeadsBindingInfo> bindings) {
        if (CollectionUtils.isEmpty(bindings)) {
            log.info("bindings are empty");
            return;
        }
        Long stageId = stageDto.getId();
        ArrayList ids = Lists.newArrayList();
        for (LeadsBindingInfo it : bindings) {
            if (stageId.equals(it.getStageId())) continue;
            ids.add(it.getId());
            log.info("\u5237\u65b0\u7ebf\u7d22\u7ed1\u5b9a\u9636\u6bb5, binding.id={}, stageId={} --> {}", new Object[]{it.getId(), it.getStageId(), stageId});
        }
        if (CollectionUtils.isEmpty((Collection)ids)) {
            log.info("\u76f8\u5173 leads_binding_info \u7684 stage_id \u5df2\u7ecf\u662f\u6700\u9ad8\u9636\u6bb5\uff0c\u65e0\u9700\u5237\u65b0\u9636\u6bb5\u3002");
            return;
        }
        this.leadsBindingInfoMapper.updateStageId(bizId, (Collection)ids, stageId, userId, new Date());
    }

    private void updateLeadsStage(Long bizId, Long userId, StageDto stageDto, List<LeadsLib> leadsLibs) {
        if (CollectionUtils.isEmpty(leadsLibs)) {
            log.info("leadsLibs are empty");
            return;
        }
        Long stageId = stageDto.getId();
        ArrayList ids = Lists.newArrayList();
        for (LeadsLib it : leadsLibs) {
            if (stageId.equals(it.getStageId())) continue;
            ids.add(it.getId());
            log.info("\u5237\u65b0\u7ebf\u7d22\u9636\u6bb5, leads.id={}, stageId={} --> {}", new Object[]{it.getId(), it.getStageId(), stageId});
            this.customerTrendService.stageUpdate(bizId, it.getId(), userId, it.getStageId(), it.getRemark(), stageId, null, null, Integer.valueOf(CustomerFollowType.MOD_STAGE.getValue()));
        }
        if (CollectionUtils.isEmpty((Collection)ids)) {
            log.info("\u76f8\u5173 leads_lib \u7684 stage_id \u5df2\u7ecf\u662f\u6700\u9ad8\u9636\u6bb5\uff0c\u65e0\u9700\u5237\u65b0\u9636\u6bb5\u3002");
            return;
        }
        this.leadsStageService.updateStage(bizId, (Collection)ids, stageId, null, null, null);
    }
}

