/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.sal.order.service.impl;

import cn.kinyun.crm.common.enums.OrderSource;
import cn.kinyun.crm.common.service.CrmOrderService;
import cn.kinyun.crm.common.service.dto.req.CrmOrderReq;
import cn.kinyun.crm.common.utils.IdGen;
import cn.kinyun.crm.dal.customer.mapper.CustomerLibMapper;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderMapper;
import cn.kinyun.crm.dal.order.mapper.CustomerOrderTradeLogMapper;
import cn.kinyun.crm.dal.util.BizTableContext;
import cn.kinyun.crm.sal.order.service.CustomerOrderService;
import cn.kinyun.crm.sal.order.service.dto.req.OrderAddReq;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOrderServiceImpl
implements CrmOrderService {
    private static final Logger log = LoggerFactory.getLogger(CrmOrderServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerLibMapper customerLibMapper;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private CustomerOrderTradeLogMapper customerOrderTradeLogMapper;
    @Autowired
    private CustomerOrderService customerOrderService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ScrmUserService scrmUserService;

    @Transactional(rollbackFor={Exception.class})
    public void addOrder(CrmOrderReq params) {
        log.info("add customer order, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCorpId()), (Object)"corpId is null");
        BizSimpleDto biz = this.scrmBizService.getByCorpId(params.getCorpId());
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)("Invalid corpId: " + params.getCorpId()));
        Preconditions.checkArgument((biz.getIsOpenCrm() != null && biz.getIsOpenCrm() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u672a\u5f00\u901aCRM\u529f\u80fd");
        OrderAddReq req = new OrderAddReq();
        BeanUtils.copyProperties((Object)params, (Object)req);
        req.setBizId(biz.getId());
        req.setSource(OrderSource.OPEN_API.getValue());
        req.validate();
        BizTableContext.putBizId((Long)biz.getId());
        this.customerOrderService.add(req);
    }
}

