/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.dal.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BizTableContext {
    private static final Logger log = LoggerFactory.getLogger(BizTableContext.class);
    public static String catalog;
    private static final ThreadLocal<Long> CONTEXT;

    private BizTableContext() {
    }

    public static void initCatalog(String catalog) {
        BizTableContext.catalog = catalog;
    }

    public static void putBizId(Long bizId) {
        CONTEXT.set(bizId);
    }

    public static void clear() {
        CONTEXT.remove();
    }

    public static Long getBizId() {
        return CONTEXT.get();
    }

    public static String getCatalog() {
        Long bizId = CONTEXT.get();
        if (bizId == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)catalog)) {
            return null;
        }
        if (bizId == 0L) {
            return String.format("`%s`", catalog);
        }
        return String.format("`%s_%d`", catalog, bizId);
    }

    public static String getSuffer() {
        Long bizId = CONTEXT.get();
        if (bizId == null) {
            return null;
        }
        return String.format("_%d", bizId);
    }

    static {
        CONTEXT = new ThreadLocal();
    }
}

