/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.dal.interceptor;

import cn.kinyun.crm.dal.annotations.AnnoEnum;
import cn.kinyun.crm.dal.util.ReflectUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class StuffInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof Executor && invocation.getArgs().length == 2) {
            Executor executor = (Executor)invocation.getTarget();
            MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
            Object paramObj = invocation.getArgs()[1];
            if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
                return this.executeInsert(executor, ms, paramObj);
            }
            if (ms.getSqlCommandType() == SqlCommandType.UPDATE) {
                return this.executeUpdate(executor, ms, paramObj);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object executeInsert(Executor executor, MappedStatement ms, Object paramObj) throws IllegalAccessException, SQLException {
        Field[] fields;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (user == null) {
            return executor.update(ms, paramObj);
        }
        for (Field field : fields = ReflectUtil.getAllFields(paramObj)) {
            field.setAccessible(true);
            Object value = field.get(paramObj);
            if (value == null) continue;
            if (field.getName().equals(AnnoEnum.CREATE_BY.getAnnoType())) {
                field.set(paramObj, user.getId());
                continue;
            }
            if (field.getName().equals(AnnoEnum.UPDATE_BY.getAnnoType())) {
                field.set(paramObj, user.getId());
                continue;
            }
            if (field.getName().equals(AnnoEnum.BIZ_ID.getAnnoType())) {
                field.set(paramObj, user.getBizId());
                continue;
            }
            if (field.getName().equals(AnnoEnum.CREATE_TIME.getAnnoType())) {
                field.set(paramObj, new Date());
                continue;
            }
            if (field.getName().equals(AnnoEnum.UPDATE_TIME.getAnnoType())) {
                field.set(paramObj, new Date());
                continue;
            }
            if (!field.getName().equals(AnnoEnum.CORP_ID.getAnnoType())) continue;
            field.set(paramObj, user.getCorpId());
        }
        return executor.update(ms, paramObj);
    }

    private Object executeUpdate(Executor executor, MappedStatement ms, Object paramObj) throws IllegalAccessException, SQLException {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (user == null) {
            return executor.update(ms, paramObj);
        }
        return executor.update(ms, paramObj);
    }
}

