/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.dal.interceptor;

import cn.kinyun.crm.dal.util.BizTableContext;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import java.sql.Connection;
import java.util.ArrayList;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class DynamicTableNameInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicTableNameInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = this.changeSql(boundSql.getSql());
        MetaObject boundSqlMeta = SystemMetaObject.forObject((Object)boundSql);
        boundSqlMeta.setValue("sql", (Object)sql);
        return invocation.proceed();
    }

    public String changeSql(String sql) {
        Long bizId = BizTableContext.getBizId();
        if (bizId == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5546\u6237id\uff0c\u8bf7\u5728\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c\u524d\uff0c\u5148\u8c03\u7528 BizTableContext.putBizId(Long) \u8bbe\u7f6e\u5546\u6237ID\u3002");
        }
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                String value = name.getValue();
                builder.append(this.changeTableName(value));
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        return builder.toString();
    }

    public String changeTableName(String tableName) {
        String catalog = BizTableContext.getCatalog();
        if (catalog == null) {
            return tableName;
        }
        if (tableName.indexOf(46) >= 0) {
            return tableName;
        }
        String name = catalog + "." + tableName;
        log.debug("change table name:{} -> {}", (Object)tableName, (Object)name);
        return name;
    }
}

