/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;

public class BeanCopier {
    private static final Logger log = LoggerFactory.getLogger(BeanCopier.class);

    public static boolean copyIfNull(Object source, Object target, String ... properties) {
        boolean isChanged = false;
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(target.getClass());
        List<String> propList = properties != null && properties.length > 0 ? Arrays.asList(properties) : null;
        log.debug("copy props={}", propList);
        for (PropertyDescriptor targetPd : targetPds) {
            Method getSource;
            String name = targetPd.getName();
            Method setTarget = targetPd.getWriteMethod();
            Method getTarget = targetPd.getReadMethod();
            if (setTarget == null || getTarget == null) {
                log.warn("lack of write/read method name:{}, getter={}, setter={}", new Object[]{name, getTarget, setTarget});
                continue;
            }
            if (propList != null && !propList.contains(name)) {
                log.debug("ignore property:{}", (Object)name);
                continue;
            }
            PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)name);
            if (sourcePd == null || (getSource = sourcePd.getReadMethod()) == null) {
                log.debug("source is null, name={}", (Object)name);
                continue;
            }
            if (!ClassUtils.isAssignable(setTarget.getParameterTypes()[0], getSource.getReturnType())) continue;
            try {
                Object origin;
                if (!Modifier.isPublic(getTarget.getDeclaringClass().getModifiers())) {
                    getTarget.setAccessible(true);
                }
                if (BeanCopier.isNotBlank(origin = getTarget.invoke(target, new Object[0]))) {
                    log.debug("ignore {}, value is not blank:{}", (Object)name, origin);
                    continue;
                }
                if (!Modifier.isPublic(getSource.getDeclaringClass().getModifiers())) {
                    getSource.setAccessible(true);
                }
                Object value = getSource.invoke(source, new Object[0]);
                if (!Modifier.isPublic(setTarget.getDeclaringClass().getModifiers())) {
                    setTarget.setAccessible(true);
                }
                setTarget.invoke(target, value);
                isChanged = true;
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
        return isChanged;
    }

    private static boolean isNotBlank(Object value) {
        if (value instanceof String) {
            return StringUtils.isNotBlank((CharSequence)((String)value));
        }
        return value != null;
    }
}

