/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.config;

import java.net.InetAddress;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class ElasticSearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${elasticsearch.scheme:http}")
    private String scheme;
    @Value(value="${elasticsearch.ip}")
    private String ip;
    @Value(value="${elasticsearch.port:9200}")
    private int port;
    @Value(value="${elasticsearch.username:}")
    private String username;
    @Value(value="${elasticsearch.password:}")
    private String password;

    @Bean
    public RestHighLevelClient elasticsearchClient() {
        log.info("init high level es client with ip={}", (Object)this.ip);
        String[] hostArray = this.ip.split(",");
        HttpHost[] httpHosts = (HttpHost[])Arrays.stream(hostArray).map(host -> new HttpHost(host, this.port, this.scheme)).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.username, this.password})) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchConfig.lambda$elasticsearchClient$2((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(builder);
    }

    @PostConstruct
    void init() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
    }

    @Lazy
    @Bean
    public IndicesAdminClient indicesAdminClient(TransportClient transportClient) {
        return transportClient.admin().indices();
    }

    @Lazy
    @Bean
    public TransportClient transportClient() {
        Settings settings = Settings.builder().put("client.transport.sniff", "false").put("cluster.name", "ali-bj-es-clusters").build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        String[] hostArray = this.ip.split(",");
        Arrays.stream(hostArray).forEach(arg_0 -> ElasticSearchConfig.lambda$transportClient$3((TransportClient)client, arg_0));
        return client;
    }

    private static /* synthetic */ void lambda$transportClient$3(TransportClient client, String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            TransportAddress transportAddress = new TransportAddress(inetAddress, 9300);
            client.addTransportAddress(transportAddress);
        }
        catch (Exception e) {
            log.error("unknown host,host={}", (Object)host, (Object)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

