/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

import java.util.Random;

public class IdGen {
    private static final long START_STAMP = 1600000000000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long SERVICE_BIT = 5L;
    public static final long MAX_DATACENTER_NUM = 31L;
    public static final long MAX_MACHINE_NUM = 31L;
    public static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long SERVICE_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private long serviceId;
    private long machineId;
    private long sequence;
    private long lastStmp = -1L;
    public static final char[] B62 = "rC1g6XU3kBDjoNfQnW0x4dO29EhqbaZHLG5vz7FJKAYSRuy8stMmcIVwpPlieT".toCharArray();

    public IdGen(long serviceId, long machineId) {
        if (serviceId > 31L || serviceId < 0L) {
            throw new IllegalArgumentException("serviceId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.serviceId = serviceId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1600000000000L << 22 | this.serviceId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public static String base62(long num) {
        StringBuilder sb = new StringBuilder();
        int remainder = 0;
        long scale = 62L;
        while (num > scale - 1L) {
            remainder = (int)(num % scale);
            sb.append(B62[remainder]);
            num /= scale;
        }
        sb.append(B62[(int)num]);
        String value = sb.reverse().toString();
        return value;
    }

    public synchronized String getNum() {
        long id = this.nextId();
        return IdGen.base62(id);
    }

    public static void main(String[] args) {
        Random rand = new Random();
        long datacenterId = rand.nextInt(31);
        long machineId = rand.nextInt(31);
        IdGen snowFlake = new IdGen(datacenterId, machineId);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            long id = snowFlake.nextId();
            String string = IdGen.base62(id);
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

