/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public final class DateUtil {
    public static final String YYYY_MM_DD_EN = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS_EN = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS_EN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Map<String, FastDateFormat> dateFormatMap = new ConcurrentHashMap<String, FastDateFormat>();

    private DateUtil() {
    }

    public static String dateToDateString(Date date, String formatStr) {
        if (formatStr == null) {
            formatStr = YYYY_MM_DD_HH_MM_SS_EN;
        }
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        return df.format(date);
    }

    public static String getCurTimeString(long time, String format) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD_HH_MM_SS_EN;
        }
        Date date = new Date(time * 1000L);
        return DateUtil.dateToDateString(date, format);
    }

    public static String getCurTimeString() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static String getCurTimeString(String formate) {
        return DateUtil.dateToDateString(new Date(), formate);
    }

    public static String getCurTimeString(long time) {
        Date date = new Date(time * 1000L);
        return DateUtil.dateToDateString(date, YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static Integer getCurTimeInt() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static FastDateFormat getDateFormat(String formatStr) {
        return dateFormatMap.computeIfAbsent(formatStr, k -> FastDateFormat.getInstance((String)formatStr));
    }

    public static Date getDate() {
        return Calendar.getInstance().getTime();
    }

    public static Date getDate(String dateTimeStr, String formatStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(formatStr);
            return sdf.parse(dateTimeStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date convertDate(String dateTimeStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(YYYY_MM_DD_EN);
            Date d = sdf.parse(dateTimeStr);
            return d;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getDate(String dateTimeStr) {
        return DateUtil.getDate(dateTimeStr, YYYY_MM_DD_EN);
    }

    public static String dateToDateString(Date date) {
        return DateUtil.dateToDateString(date, YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static String stringToDateString(String date, String formatStr1, String formatStr2) {
        Date d = DateUtil.getDate(date, formatStr1);
        FastDateFormat df = DateUtil.getDateFormat(formatStr2);
        return df.format(d);
    }

    public static String getCurDate() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_EN);
    }

    public static String getCurDate(String formatStr) {
        return DateUtil.dateToDateString(new Date(), formatStr);
    }

    public static String getCurCNDate() {
        return DateUtil.dateToDateString(new Date(), "yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static String getCurDateTime() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static String getCurZhCNDateTime() {
        return DateUtil.dateToDateString(new Date(), "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
    }

    public static long compareDateStr(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_SSS_EN);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_SSS_EN);
        return d2.getTime() - d1.getTime();
    }

    public static long compareDateMinute(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_SSS_EN);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_SSS_EN);
        long time = d2.getTime() - d1.getTime();
        return time / 60000L;
    }

    public static long compareDateDay(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_EN);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_EN);
        long time = d2.getTime() - d1.getTime();
        return time / 86400000L;
    }

    public static Integer getMinuToMill(Integer minutes) {
        if (null == minutes) {
            return null;
        }
        return minutes * 60;
    }

    public static Long getTheDateBegin(String date) {
        date = date + " 00:00:00";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS_EN).getTime();
    }

    public static Long getTheDateEnd(String date) {
        date = date + " 23:59:59";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS_EN).getTime();
    }

    public static Long getTheDateBegin(Date date) {
        return DateUtil.getTheDateBegin(DateUtil.dateToDateString(date, YYYY_MM_DD_EN));
    }

    public static Long getTheDateEnd(Date date) {
        return DateUtil.getTheDateEnd(DateUtil.dateToDateString(date, YYYY_MM_DD_EN));
    }

    public static String timeTosec(String time) {
        if ("null".equals(time) || StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        if (time.length() <= 5) {
            time = time + ":00";
        }
        int index1 = time.indexOf(":");
        int index2 = time.indexOf(":", index1 + 1);
        int hh = Integer.parseInt(time.substring(0, index1));
        int mi = Integer.parseInt(time.substring(index1 + 1, index2));
        int ss = Integer.parseInt(time.substring(index2 + 1));
        return hh * 60 * 60 + mi * 60 + ss + "";
    }

    public static String secToTime(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return null;
        }
        int time = Integer.parseInt(timeStr);
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = DateUtil.unitFormat(hour) + ":" + DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        }
        return timeStr;
    }

    public static Integer getSecToMinu(Integer second) {
        if (null == second) {
            return null;
        }
        return second / 60;
    }

    public static String secToTime(int time) {
        String timeStr = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = DateUtil.unitFormat(hour) + ":" + DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        }
        return timeStr;
    }

    public static String unitFormat(int i) {
        String retStr = null;
        retStr = i >= 0 && i < 10 ? "0" + i : "" + i;
        return retStr;
    }

    public static long getStrToLong(String timeStr, String format) {
        return DateUtil.getDate(timeStr, format).getTime();
    }

    public static boolean isTimeBefor(Date nows, Date date) {
        long hous = nows.getTime() - date.getTime();
        return hous > 0L;
    }

    public static long getMicroSec(BigDecimal hours) {
        BigDecimal bd = hours.multiply(new BigDecimal(3600000));
        return bd.longValue();
    }

    public static String getDateStringOfYear(int years, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(1, years);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfMon(int months, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(2, months);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfDay(int days, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(5, days);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static boolean theDateIsToday(String date, String format) {
        String theDate = DateUtil.stringToDateString(date, format, "yyyyMMdd");
        String today = DateUtil.getDateStringOfDay(0, "yyyyMMdd");
        return theDate.equals(today);
    }

    public static String getDateStringOfHour(int hours, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(11, hours);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateOfMin(String date, int mins, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(DateUtil.getDate(date, formatStr));
        now.add(13, mins * 60);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfMin(int mins, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(12, mins);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static Date getDateOfMin(int mins) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(12, mins);
        return now.getTime();
    }

    public static String getDateStringOfSec(int sec, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(13, sec);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateOfSec(String date, int sec, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(DateUtil.getDate(date, formatStr));
        now.add(13, sec);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static int getMonthDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static int getCurentMonthDay() {
        Date date = Calendar.getInstance().getTime();
        return DateUtil.getMonthDay(date);
    }

    public static int getMonthDay(String date) {
        Date strDate = DateUtil.getDate(date, YYYY_MM_DD_EN);
        return DateUtil.getMonthDay(strDate);
    }

    public static int getYear(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(1);
    }

    public static int getMonth(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(2) + 1;
    }

    public static int getDay(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(5);
    }

    public static int getHour(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(11);
    }

    public static int getMin(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(12);
    }

    public static int getSecond(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(13);
    }

    public static String getMondayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return DateUtil.dateToDateString(c.getTime(), YYYY_MM_DD_EN);
    }

    public static String getSundayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 7);
        return DateUtil.dateToDateString(c.getTime());
    }

    public static String getDayOfThisWeek(int num) {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + num);
        return DateUtil.dateToDateString(c.getTime(), YYYY_MM_DD_EN);
    }

    public static String getDayOfThisMoon(String num) {
        String date = DateUtil.dateToDateString(new Date(), "yyyy-MM");
        date = date + "-" + num;
        return date;
    }

    public static long getQuotByDays(String beginDate, String endDate) {
        long quot = 0L;
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD_EN);
        try {
            Date d1 = df.parse(beginDate);
            Date d2 = df.parse(endDate);
            quot = d2.getTime() - d1.getTime();
            quot = quot / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return quot;
    }

    public static int getQuotByDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static String getDateAddDay(String date, int days) {
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD_EN);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(date));
            cal.add(5, days);
            date = df.format(cal.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static Date getDateAddDay(Date date, int days) {
        Calendar no = Calendar.getInstance();
        no.setTime(date);
        no.add(5, days);
        return no.getTime();
    }

    public static String getDateAddMonth(String date, int m) {
        FastDateFormat df = DateUtil.getDateFormat("yyyyMM");
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(date));
            cal.add(2, m);
            date = df.format(cal.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static String getYesterday(Date date) throws ParseException {
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD_EN);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(df.parse(df.format(date)));
        calendar.add(5, -1);
        return df.format(calendar.getTime());
    }

    public static Date getLastDayOfCurrMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        cal.set(5, 0);
        return cal.getTime();
    }

    public static String getIntToStr(String dateInt, String format) {
        FastDateFormat df = DateUtil.getDateFormat(format);
        long times = (long)Integer.parseInt(dateInt) * 1000L;
        Date date = new Date(times);
        return df.format(date);
    }

    public static String getNowTime(String format) {
        FastDateFormat df = DateUtil.getDateFormat(format);
        long times = System.currentTimeMillis();
        Date date = new Date(times);
        return df.format(date);
    }

    public static long getTenTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getMillsStr(long time) {
        String timeStr = String.valueOf(time);
        String suffix = timeStr.substring(0, timeStr.length() - 3);
        String prefix = timeStr.substring(timeStr.length() - 3);
        return suffix + "." + prefix;
    }

    public static Long getTodayTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static int getTodayOfWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        return day_of_week;
    }

    public static Integer getTodayInt() {
        return (int)(DateUtil.getTodayTime() / 1000L);
    }

    public static Long getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getStartTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 0);
        todayEnd.set(12, 0);
        todayEnd.set(13, 0);
        todayEnd.set(14, 0);
        return todayEnd.getTime().getTime();
    }

    public static Date getTodayEndTime() {
        return new Date(DateUtil.getEndTime());
    }

    public static Date getTodayStartTime() {
        return new Date(DateUtil.getStartTime());
    }

    public static Integer getTomorrowInt() {
        return (int)(DateUtil.getTomorrowTime() / 1000L);
    }

    public static Long getTomorrowTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        return cal.getTime().getTime();
    }

    public static String longToString(String timeStr, String format) {
        long times = Long.parseLong(timeStr.replace(".", ""));
        return DateUtil.longToStr(times, format);
    }

    public static String longToStr(long times, String format) {
        Date date = new Date(times);
        return DateUtil.dateToDateString(date, format);
    }

    public static Long getPointHourTime(int hour) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, hour);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static boolean isDate(String dateTimeStr, String formatStr) {
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        try {
            df.parse(dateTimeStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String dateStrFormat(String dateStr, String formatStr) {
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        try {
            return df.format(df.parse(dateStr));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getWeekOfYear(Date d) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(d);
        return calendar.get(3);
    }

    public static Date getPointHourDate(int hour) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.add(10, hour);
        return todayStart.getTime();
    }

    public static boolean isTheSameDay(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getTodayOfWeek());
    }
}

