/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

import cn.kinyun.crm.common.utils.DateUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.File;
import java.util.Date;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunOssUtils {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssUtils.class);
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.roleArn}")
    private String roleArn;
    @Value(value="${aliyun.oss.bucket}")
    private String bucket;
    @Value(value="${aliyun.oss.file.expireDays}")
    private long expireDays;
    private static String endpoint_static;
    private static String accessKeyId_static;
    private static String accessKeySecret_static;
    private static String roleArn_static;
    private static String bucket_static;
    private static long expireDays_static;

    public static AssumeRoleResponse getSTS() throws ClientException {
        String accessKeyId = accessKeyId_static;
        String accessKeySecret = accessKeySecret_static;
        String roleArn = roleArn_static;
        String roleSessionName = "session-name";
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)accessKeyId, (String)accessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setProtocol(ProtocolType.HTTPS);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            return response;
        }
        catch (Exception e) {
            log.error("STS Request Failed e{}", (Throwable)e);
            throw e;
        }
    }

    @PostConstruct
    public void init() {
        endpoint_static = this.endpoint;
        accessKeyId_static = this.accessKeyId;
        accessKeySecret_static = this.accessKeySecret;
        roleArn_static = this.roleArn;
        bucket_static = this.bucket;
        expireDays_static = this.expireDays;
    }

    public static void main(String[] args) {
        String dateStr = DateUtil.dateToDateString(new Date(), "yyyyMMdd");
        System.out.println("crm/corpId" + File.separator + dateStr + File.separator);
    }

    public static String uploadFile(String corpId, File file, String originFileKey) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new IllegalArgumentException("corpId can not be null or empty");
        }
        String dateStr = DateUtil.dateToDateString(new Date(), "yyyyMMdd");
        String fileDir = "crm/" + corpId + File.separator + dateStr + File.separator;
        OSS ossClient = new OSSClientBuilder().build(endpoint_static, accessKeyId_static, accessKeySecret_static);
        String fileKey = StringUtils.isNotBlank((CharSequence)originFileKey) ? fileDir + originFileKey : fileDir + UUID.randomUUID().toString().replace("-", "") + "-" + file.getName();
        ossClient.putObject(bucket_static, fileKey, file);
        ossClient.shutdown();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://").append(bucket_static).append(".").append(endpoint_static).append("/").append(fileKey);
        return urlBuilder.toString();
    }

    public static void delUploadFile(String corpId, String originFileKey) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new IllegalArgumentException("corpId can not be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)originFileKey)) {
            throw new IllegalArgumentException("originFileKey can not be null or empty");
        }
        String dateStr = DateUtil.dateToDateString(new Date(), "yyyyMMdd");
        String fileDir = "crm/" + corpId + File.separator + dateStr + File.separator;
        String fileKey = fileDir + originFileKey;
        OSS ossClient = new OSSClientBuilder().build(endpoint_static, accessKeyId_static, accessKeySecret_static);
        ossClient.deleteObject(bucket_static, fileKey);
        ossClient.shutdown();
    }
}

