/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.annotation.FieldDesc;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoExportExcel {
    private static final Logger log = LoggerFactory.getLogger(PojoExportExcel.class);

    public static void writeExportFile(HttpServletResponse response, String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String returnName = file.getName();
        response.reset();
        ServletOutputStream os = response.getOutputStream();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(returnName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        FileInputStream fileInputStream = new FileInputStream(file);
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)os, (int)4048);
    }

    public static <T> void doPrint(List<T> beanList, Class<T> clazz, String sheetName, String filePath) throws Exception {
        try (FileOutputStream fileWriter = new FileOutputStream(filePath);){
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet(sheetName);
            HashMap lengthMap = Maps.newHashMap();
            PojoExportExcel.printHeader(clazz, (Workbook)wb, (Sheet)sheet, lengthMap);
            PojoExportExcel.printValue(beanList, clazz, (Workbook)wb, (Sheet)sheet, 1, lengthMap);
            wb.write((OutputStream)fileWriter);
            wb.close();
        }
    }

    public static <T> void doPrintHeader(Class<T> clazz, String sheetName, String filePath, Map<String, Integer> lengthMap) throws IOException {
        FileOutputStream fileWriter = new FileOutputStream(filePath);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetName);
        PojoExportExcel.printHeader(clazz, (Workbook)workbook, (Sheet)sheet, lengthMap);
        workbook.write((OutputStream)fileWriter);
        workbook.close();
    }

    public static <T> Integer doPrintValue(List<T> beanList, Class<T> clazz, String sheetName, String filePath, Integer startRow, Map<String, Integer> lengthMap) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);
             FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);
            SXSSFWorkbook wb = new SXSSFWorkbook(workbook);
            SXSSFSheet sheet = wb.getSheet(sheetName);
            startRow = PojoExportExcel.printValue(beanList, clazz, (Workbook)wb, (Sheet)sheet, startRow, lengthMap);
            wb.write((OutputStream)fileOutputStream);
        }
        return startRow;
    }

    public static <T> void printHeader(Class<T> clazz, Workbook wb, Sheet sheet, Map<String, Integer> lengthMap) {
        Row nRow = sheet.createRow(0);
        nRow.setHeightInPoints(20.0f);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList fieldList = Lists.newArrayListWithCapacity((int)fields.length);
        for (Field field : fields) {
            FieldDesc fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
            if (fieldDesc == null) continue;
            fieldList.add(fieldDesc.desc());
        }
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5\u4fe1\u606f");
        }
        CellStyle headerStyle = PojoExportExcel.getCellStyle(wb, true);
        Cell nCell = null;
        Integer cellNo = 0;
        for (String fieldName : fieldList) {
            Integer length = fieldName.length() * 4 * 256;
            sheet.setColumnWidth(cellNo.intValue(), length.intValue());
            lengthMap.put(fieldName, length);
            Integer n = cellNo;
            Integer n2 = cellNo = Integer.valueOf(cellNo + 1);
            nCell = nRow.createCell(n.intValue());
            nCell.setCellValue(fieldName);
            nCell.setCellStyle(headerStyle);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static <T> int printValue(List<T> beanList, Class<T> clazz, Workbook wb, Sheet sheet, Integer rowNo, Map<String, Integer> lengthMap) throws Exception {
        headerFieldMap = Maps.newHashMap();
        percentMap = Maps.newHashMap();
        percentLengthMap = Maps.newHashMap();
        dateFormatMap = Maps.newHashMap();
        fields = clazz.getDeclaredFields();
        fieldList = Lists.newArrayListWithCapacity((int)fields.length);
        for (Field field : fields) {
            fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
            if (fieldDesc == null) continue;
            fieldList.add(fieldDesc.desc());
            headerFieldMap.put(fieldDesc.desc(), field.getName());
            percentMap.put(fieldDesc.desc(), fieldDesc.percent());
            percentLengthMap.put(fieldDesc.desc(), fieldDesc.percentLenth());
            dateFormatMap.put(fieldDesc.desc(), fieldDesc.dateFormat());
        }
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5\u4fe1\u606f");
        }
        contentStyle = PojoExportExcel.getCellStyle(wb, false);
        cellNo = 0;
        nRow = null;
        nCell = null;
        for (T t : beanList) {
            var18_20 = rowNo;
            rowNo = Integer.valueOf(rowNo + 1);
            var19_21 = rowNo;
            nRow = sheet.createRow(var18_20.intValue());
            valueMap = Maps.newHashMap();
            for (Field field : fields) {
                fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
                if (fieldDesc == null) continue;
                field.setAccessible(true);
                valueMap.put(fieldDesc.desc(), field.get(t));
            }
            for (String showName : fieldList) {
                var21_25 = cellNo;
                field = cellNo = Integer.valueOf(cellNo + 1);
                nCell = nRow.createCell(var21_25.intValue());
                obj = valueMap.get(showName);
                if (obj != null) {
                    percent = (Boolean)percentMap.get(showName);
                    if (percent) {
                        percentLength = (Integer)percentLengthMap.get(showName);
                        number = null;
                        try {
                            number = (Number)obj;
                            if (percentLength == 100) {
                                b = BigDecimal.valueOf(number.doubleValue()).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                                nCell.setCellValue(b.doubleValue());
                            }
                            if (percentLength != 10000) ** GOTO lbl79
                            b = BigDecimal.valueOf(number.doubleValue()).divide(new BigDecimal(10000)).setScale(4, RoundingMode.HALF_UP);
                            nCell.setCellValue(b.doubleValue());
                        }
                        catch (ClassCastException e) {
                            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9700\u8981\u6253\u5370\u7684\u5b57\u6bb5\u4e0d\u4e3a\u6570\u503c\uff0c\u63cf\u8ff0\u4fe1\u606f\u9519\u8bef");
                        }
                    } else if (obj instanceof Node) {
                        nCell.setCellValue(((Node)obj).getName());
                    } else if (obj instanceof Date) {
                        date = (Date)obj;
                        format = dateFormatMap.getOrDefault(showName, "yyyy-MM-dd HH:mm:ss");
                        sdf = new SimpleDateFormat(format);
                        nCell.setCellValue(sdf.format(date));
                    } else if (obj instanceof List) {
                        list = (List)obj;
                        size = list.size();
                        if (size > 0) {
                            nRow.setHeightInPoints((float)(20 * size));
                            nCell.setCellValue(StringUtils.join((Iterable)list, (String)"\r\n"));
                        }
                    } else {
                        nCell.setCellValue(obj.toString());
                    }
lbl79:
                    // 7 sources

                    oldMaxLength = 1536;
                    if (lengthMap.get(showName) != null) {
                        oldMaxLength = lengthMap.get(showName);
                    }
                    valueLength = obj.toString().length() * 2 * 256;
                    if (obj instanceof List && (list = (List)obj).size() > 0 && StringUtils.isNotBlank((CharSequence)(str = (String)list.get(0)))) {
                        valueLength = Math.min(str.length() * 2 * 256, 15360);
                    }
                    if (obj instanceof Date) {
                        format = dateFormatMap.getOrDefault(showName, "yyyy-MM-dd HH:mm:ss");
                        valueLength = format.length() * 256;
                    }
                    if ((maxLength = Math.max(oldMaxLength, valueLength)) > 65280) {
                        maxLength = 65280;
                    }
                    sheet.setColumnWidth(cellNo - 1, maxLength);
                    lengthMap.put(showName, maxLength);
                }
                nCell.setCellStyle(contentStyle);
            }
            cellNo = 0;
        }
        return rowNo;
    }

    private static CellStyle getCellStyle(Workbook wb, boolean bold) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        Font font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(bold);
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }
}

