/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

public final class FileSize {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;

    private FileSize() {
    }

    public static String format(long fileSize) {
        if (fileSize < 1024L) {
            return String.format("%d Bytes", fileSize);
        }
        if (fileSize < 0x100000L) {
            float val = (float)fileSize / 1024.0f;
            return String.format("%.2f KB", Float.valueOf(val));
        }
        if (fileSize < 0x40000000L) {
            float val = (float)(fileSize >> 10) / 1024.0f;
            return String.format("%.2f MB", Float.valueOf(val));
        }
        if (fileSize < 0x10000000000L) {
            float val = (float)(fileSize >> 20) / 1024.0f;
            return String.format("%.2f GB", Float.valueOf(val));
        }
        if (fileSize < 0x4000000000000L) {
            float val = (float)(fileSize >> 30) / 1024.0f;
            return String.format("%.2f TB", Float.valueOf(val));
        }
        float val = (float)(fileSize >> 40) / 1024.0f;
        return String.format("%.2f PB", Float.valueOf(val));
    }
}

