/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.utils;

import cn.kinyun.crm.common.annotations.FieldProperty;
import cn.kinyun.crm.common.annotations.LeadsField;
import cn.kinyun.crm.common.dto.thead.THeadCelDto;
import cn.kinyun.crm.common.dto.thead.THeadGroupItem;
import cn.kinyun.crm.common.enums.TableGroup;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

public final class ApiModelParser {
    public static final String EXTEND_FIELD_DESC = "extend_field";
    public static final int MAX_DEEP = 3;

    private ApiModelParser() {
    }

    public static List<THeadCelDto> parse(Class dtoCls) {
        return ApiModelParser.parse(dtoCls, 0);
    }

    private static List<THeadCelDto> parse(Class dtoCls, int deep) {
        Field[] fields;
        if (deep >= 3) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        if (dtoCls.getSuperclass() != null) {
            result.addAll(ApiModelParser.parse(dtoCls.getSuperclass(), deep + 1));
        }
        for (Field field : fields = dtoCls.getDeclaredFields()) {
            ApiModelProperty property;
            if (!BeanUtils.isSimpleValueType(field.getType())) {
                result.addAll(ApiModelParser.parse(field.getType(), deep + 1));
            }
            if ((property = field.getDeclaredAnnotation(ApiModelProperty.class)) == null) continue;
            THeadCelDto tHeadCelDto = THeadCelDto.builder().fieldName(field.getName()).name(property.value()).build();
            LeadsField leadsField = field.getDeclaredAnnotation(LeadsField.class);
            if (leadsField != null) {
                tHeadCelDto.setRelateFieldName(leadsField.value());
            }
            result.add(tHeadCelDto);
        }
        return result;
    }

    public static List<THeadGroupItem> parseGroup(Class dtoCls) {
        List<THeadGroupItem> results = ApiModelParser.parseByGroup(dtoCls, 0);
        for (THeadGroupItem item : results) {
            if (!CollectionUtils.isNotEmpty(item.getFields())) continue;
            item.setFields(item.getFields().stream().sorted((a, b) -> Integer.compare(a.getSeq(), b.getSeq())).collect(Collectors.toList()));
        }
        return results;
    }

    private static List<THeadGroupItem> parseByGroup(Class dtoCls, int deep) {
        Field[] fields;
        if (Objects.isNull(dtoCls)) {
            return Lists.newArrayList();
        }
        if (deep >= 3) {
            return Lists.newArrayList();
        }
        HashMap groupName2Item = Maps.newHashMap();
        if (dtoCls.getSuperclass() != null) {
            ApiModelParser.collectGroupItem(dtoCls, deep + 1, groupName2Item);
        }
        for (Field field : fields = dtoCls.getDeclaredFields()) {
            FieldProperty property;
            if (!BeanUtils.isSimpleValueType(field.getType())) {
                ApiModelParser.collectGroupItem(field.getType(), deep + 1, groupName2Item);
            }
            if ((property = field.getDeclaredAnnotation(FieldProperty.class)) == null) continue;
            TableGroup tableGroup = TableGroup.getTableGroupByName(property.groupName());
            THeadGroupItem tHeadGroupItem = (THeadGroupItem)groupName2Item.get(property.groupName());
            if (tHeadGroupItem == null) {
                tHeadGroupItem = THeadGroupItem.builder().groupName(property.groupName()).groupCNName(tableGroup != null ? tableGroup.getCnName() : "").seq(tableGroup != null ? tableGroup.getSeq() : 0).fields(Lists.newArrayList()).build();
            }
            THeadCelDto dto = THeadCelDto.builder().fieldName(field.getName()).name(property.value()).seq(property.seq()).build();
            tHeadGroupItem.getFields().add(dto);
            LeadsField leadsField = field.getDeclaredAnnotation(LeadsField.class);
            if (leadsField != null) {
                dto.setRelateFieldName(leadsField.value());
            }
            groupName2Item.put(property.groupName(), tHeadGroupItem);
        }
        return groupName2Item.values().stream().sorted((a, b) -> Integer.compare(a.getSeq(), b.getSeq())).collect(Collectors.toList());
    }

    private static void collectGroupItem(Class dtoCls, int deep, Map<String, THeadGroupItem> groupName2Item) {
        List<THeadGroupItem> temResult = ApiModelParser.parseByGroup(dtoCls.getSuperclass(), deep);
        temResult.forEach(a -> {
            THeadGroupItem item = (THeadGroupItem)groupName2Item.get(a.getGroupName());
            if (item != null) {
                if (null == item.getFields()) {
                    item.setFields(Lists.newArrayList());
                }
                if (CollectionUtils.isNotEmpty(a.getFields())) {
                    item.getFields().addAll(a.getFields());
                }
                List<THeadCelDto> fields = item.getFields().stream().sorted((x, y) -> Integer.compare(x.getSeq(), y.getSeq())).collect(Collectors.toList());
                item.setFields(fields);
            } else {
                groupName2Item.put(a.getGroupName(), (THeadGroupItem)a);
            }
        });
    }
}

