/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.enums;

import cn.kinyun.crm.common.enums.EnumService;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TimeType implements EnumService
{
    TODAY(0, "\u4eca\u65e5"),
    THIS_WEEK(1, "\u672c\u5468"),
    THIS_MONTH(2, "\u672c\u6708");

    private static final Map<Integer, TimeType> cache;
    private int value;
    private String desc;

    private TimeType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static TimeType getByType(Integer type) {
        return cache.get(type);
    }

    static {
        cache = ImmutableMap.copyOf(Arrays.stream(TimeType.values()).collect(Collectors.toMap(TimeType::getValue, Function.identity())));
    }
}

