/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum TableGroup {
    CUSTOMER_INFO("customerInfo", "\u5ba2\u6237\u4fe1\u606f", 1),
    BIND_INFO("bindInfo", "\u7ed1\u5b9a\u4fe1\u606f", 2),
    RESOURCE_INFO("resourceInfo", "\u8d44\u6e90\u4fe1\u606f", 3),
    FOLLOW_RECORD("followRecord", "\u8ddf\u8fdb\u8bb0\u5f55", 4),
    FOLLOW_STATISTICS("followStatistics", "\u8ddf\u8fdb\u60c5\u51b5", 5),
    CUSTOMER_TAGS("customerTags", "\u5ba2\u6237\u6807\u7b7e", 6),
    BUSINESS_INFO("businessInfo", "\u4e1a\u52a1\u4fe1\u606f", 7),
    ORDER_INFO("orderInfo", "\u8ba2\u5355\u4fe1\u606f", 8);

    private String name;
    private String cnName;
    private int seq;
    private static final Map<String, TableGroup> MAP;

    public String getName() {
        return this.name;
    }

    public String getCnName() {
        return this.cnName;
    }

    public int getSeq() {
        return this.seq;
    }

    private TableGroup(String name, String cnName, int seq) {
        this.name = name;
        this.cnName = cnName;
        this.seq = seq;
    }

    public static List<TableGroup> getAll() {
        return Arrays.stream(TableGroup.values()).sorted((a, b) -> {
            if (a.getSeq() > b.getSeq()) {
                return 1;
            }
            if (a.getSeq() < b.getSeq()) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public static TableGroup getTableGroupByName(String groupName) {
        return MAP.get(groupName);
    }

    static {
        MAP = Arrays.stream(TableGroup.values()).collect(Collectors.toMap(TableGroup::getName, a -> a));
    }
}

