/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.enums;

import cn.kinyun.crm.common.enums.EnumService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public enum HandleTypeEnum implements EnumService
{
    TO_SYSTEM(1, "\u7cfb\u7edf\u81ea\u52a8\u5206\u914d"),
    TO_WECHAT(2, "\u5206\u914d\u5230\u5fae\u4fe1\u597d\u53cb\u6210\u5458"),
    TO_DEALER(3, "\u5206\u914d\u7ed9\u6210\u5355\u4eba,\u65e0\u6210\u5355\u4eba\u7cfb\u7edf\u5206\u914d"),
    TO_SHARER(4, "\u5206\u914d\u7ed9\u5206\u4eab\u4eba"),
    TO_FOLLOWER(5, "\u5206\u914d\u7ed9\u6307\u5b9a\u8ddf\u8fdb\u4eba"),
    TO_LEADS_CLEAN(6, "\u5206\u914d\u5230\u7ebf\u7d22\u6e05\u6d17\u6c60");

    private final int value;
    private final String desc;
    private static final Map<Integer, HandleTypeEnum> CACHE;

    private HandleTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static HandleTypeEnum getType(Integer value) {
        return CACHE.get(value);
    }

    public static String getTypeDesc(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Optional.ofNullable(CACHE.get(value)).map(HandleTypeEnum::getDesc).orElse(null);
    }

    static {
        HashMap<Integer, HandleTypeEnum> map = new HashMap<Integer, HandleTypeEnum>();
        for (HandleTypeEnum e : HandleTypeEnum.values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }
}

