/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.common.dto.conf.req;

import cn.kinyun.crm.common.enums.AllocMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="\u6e05\u6d17\u89c4\u5219\u8bf7\u6c42\u4fe1\u606f\u6a21\u578b")
public class ShuffleRuleReqDto {
    @ApiModelProperty(value="\u7f16\u8f91\u65f6\u4f7f\u7528")
    private String num;
    @ApiModelProperty(value="\u5206\u914d\u6a21\u578b")
    private int allocMode = AllocMode.ROUND.getValue();
    @ApiModelProperty(value="\u8868\u8fbe\u5f0f\u903b\u8f91\u5173\u7cfb:and = 0;or=1")
    private int logic;
    @ApiModelProperty(value="\u8868\u8fbe\u5f0f\u5217\u8868")
    private List<ExpressionReqDto> expressionList;
    @ApiModelProperty(value="\u9500\u552e\u7ebf")
    private String productLineNum;
    @ApiModelProperty(value="\u7701")
    private String provinceId;
    @ApiModelProperty(value="\u5e02")
    private String cityId;
    @ApiModelProperty(value="\u6e05\u6d17\u4eba\u5458")
    private List<AimDto> aims;

    public void checkMod() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.num), (Object)"num is null!");
        this.checkAdd();
    }

    public void checkAdd() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.productLineNum), (Object)"productLineNum is null!");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.aims), (Object)"aims is null!");
        for (AimDto aim : this.aims) {
            aim.validate();
        }
    }

    public void checkAim() {
        HashSet daySet = Sets.newHashSet();
        ArrayList dayList = Lists.newArrayList();
        for (AimDto aimDto : this.aims) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(aimDto.getUserIds()), (Object)"\u672a\u6307\u5b9a\u5206\u914d\u4eba");
            daySet.addAll(aimDto.days);
            dayList.addAll(aimDto.days);
        }
        Preconditions.checkArgument((daySet.size() == dayList.size() ? 1 : 0) != 0, (Object)"\u65e5\u671f\u4e0d\u80fd\u91cd\u590d\uff01");
    }

    public static ShuffleRuleReqDtoBuilder builder() {
        return new ShuffleRuleReqDtoBuilder();
    }

    public String getNum() {
        return this.num;
    }

    public int getAllocMode() {
        return this.allocMode;
    }

    public int getLogic() {
        return this.logic;
    }

    public List<ExpressionReqDto> getExpressionList() {
        return this.expressionList;
    }

    public String getProductLineNum() {
        return this.productLineNum;
    }

    public String getProvinceId() {
        return this.provinceId;
    }

    public String getCityId() {
        return this.cityId;
    }

    public List<AimDto> getAims() {
        return this.aims;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setAllocMode(int allocMode) {
        this.allocMode = allocMode;
    }

    public void setLogic(int logic) {
        this.logic = logic;
    }

    public void setExpressionList(List<ExpressionReqDto> expressionList) {
        this.expressionList = expressionList;
    }

    public void setProductLineNum(String productLineNum) {
        this.productLineNum = productLineNum;
    }

    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public void setAims(List<AimDto> aims) {
        this.aims = aims;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShuffleRuleReqDto)) {
            return false;
        }
        ShuffleRuleReqDto other = (ShuffleRuleReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAllocMode() != other.getAllocMode()) {
            return false;
        }
        if (this.getLogic() != other.getLogic()) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        List<ExpressionReqDto> this$expressionList = this.getExpressionList();
        List<ExpressionReqDto> other$expressionList = other.getExpressionList();
        if (this$expressionList == null ? other$expressionList != null : !((Object)this$expressionList).equals(other$expressionList)) {
            return false;
        }
        String this$productLineNum = this.getProductLineNum();
        String other$productLineNum = other.getProductLineNum();
        if (this$productLineNum == null ? other$productLineNum != null : !this$productLineNum.equals(other$productLineNum)) {
            return false;
        }
        String this$provinceId = this.getProvinceId();
        String other$provinceId = other.getProvinceId();
        if (this$provinceId == null ? other$provinceId != null : !this$provinceId.equals(other$provinceId)) {
            return false;
        }
        String this$cityId = this.getCityId();
        String other$cityId = other.getCityId();
        if (this$cityId == null ? other$cityId != null : !this$cityId.equals(other$cityId)) {
            return false;
        }
        List<AimDto> this$aims = this.getAims();
        List<AimDto> other$aims = other.getAims();
        return !(this$aims == null ? other$aims != null : !((Object)this$aims).equals(other$aims));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShuffleRuleReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAllocMode();
        result = result * 59 + this.getLogic();
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        List<ExpressionReqDto> $expressionList = this.getExpressionList();
        result = result * 59 + ($expressionList == null ? 43 : ((Object)$expressionList).hashCode());
        String $productLineNum = this.getProductLineNum();
        result = result * 59 + ($productLineNum == null ? 43 : $productLineNum.hashCode());
        String $provinceId = this.getProvinceId();
        result = result * 59 + ($provinceId == null ? 43 : $provinceId.hashCode());
        String $cityId = this.getCityId();
        result = result * 59 + ($cityId == null ? 43 : $cityId.hashCode());
        List<AimDto> $aims = this.getAims();
        result = result * 59 + ($aims == null ? 43 : ((Object)$aims).hashCode());
        return result;
    }

    public String toString() {
        return "ShuffleRuleReqDto(num=" + this.getNum() + ", allocMode=" + this.getAllocMode() + ", logic=" + this.getLogic() + ", expressionList=" + this.getExpressionList() + ", productLineNum=" + this.getProductLineNum() + ", provinceId=" + this.getProvinceId() + ", cityId=" + this.getCityId() + ", aims=" + this.getAims() + ")";
    }

    public ShuffleRuleReqDto(String num, int allocMode, int logic, List<ExpressionReqDto> expressionList, String productLineNum, String provinceId, String cityId, List<AimDto> aims) {
        this.num = num;
        this.allocMode = allocMode;
        this.logic = logic;
        this.expressionList = expressionList;
        this.productLineNum = productLineNum;
        this.provinceId = provinceId;
        this.cityId = cityId;
        this.aims = aims;
    }

    public ShuffleRuleReqDto() {
    }

    public static class ShuffleRuleReqDtoBuilder {
        private String num;
        private int allocMode;
        private int logic;
        private List<ExpressionReqDto> expressionList;
        private String productLineNum;
        private String provinceId;
        private String cityId;
        private List<AimDto> aims;

        ShuffleRuleReqDtoBuilder() {
        }

        public ShuffleRuleReqDtoBuilder num(String num) {
            this.num = num;
            return this;
        }

        public ShuffleRuleReqDtoBuilder allocMode(int allocMode) {
            this.allocMode = allocMode;
            return this;
        }

        public ShuffleRuleReqDtoBuilder logic(int logic) {
            this.logic = logic;
            return this;
        }

        public ShuffleRuleReqDtoBuilder expressionList(List<ExpressionReqDto> expressionList) {
            this.expressionList = expressionList;
            return this;
        }

        public ShuffleRuleReqDtoBuilder productLineNum(String productLineNum) {
            this.productLineNum = productLineNum;
            return this;
        }

        public ShuffleRuleReqDtoBuilder provinceId(String provinceId) {
            this.provinceId = provinceId;
            return this;
        }

        public ShuffleRuleReqDtoBuilder cityId(String cityId) {
            this.cityId = cityId;
            return this;
        }

        public ShuffleRuleReqDtoBuilder aims(List<AimDto> aims) {
            this.aims = aims;
            return this;
        }

        public ShuffleRuleReqDto build() {
            return new ShuffleRuleReqDto(this.num, this.allocMode, this.logic, this.expressionList, this.productLineNum, this.provinceId, this.cityId, this.aims);
        }

        public String toString() {
            return "ShuffleRuleReqDto.ShuffleRuleReqDtoBuilder(num=" + this.num + ", allocMode=" + this.allocMode + ", logic=" + this.logic + ", expressionList=" + this.expressionList + ", productLineNum=" + this.productLineNum + ", provinceId=" + this.provinceId + ", cityId=" + this.cityId + ", aims=" + this.aims + ")";
        }
    }

    @ApiModel(value="\u8868\u8fbe\u5f0f\u6a21\u578b")
    public static class ExpressionReqDto {
        @ApiModelProperty(value="\u5b57\u6bb5")
        private String fieldName;
        @ApiModelProperty(value="\u5b57\u6bb5\u7c7b\u578b")
        private Integer type;
        @ApiModelProperty(value="\u64cd\u4f5c\u7b26")
        private int op;
        @ApiModelProperty(value="\u53f3\u4fa7\u503c")
        private Object value;
        @ApiModelProperty(value="\u53f3\u4fa7\u591a\u503c")
        private List<Object> values;

        public static ExpressionReqDtoBuilder builder() {
            return new ExpressionReqDtoBuilder();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Integer getType() {
            return this.type;
        }

        public int getOp() {
            return this.op;
        }

        public Object getValue() {
            return this.value;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public void setOp(int op) {
            this.op = op;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setValues(List<Object> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionReqDto)) {
                return false;
            }
            ExpressionReqDto other = (ExpressionReqDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOp() != other.getOp()) {
                return false;
            }
            Integer this$type = this.getType();
            Integer other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            List<Object> this$values = this.getValues();
            List<Object> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpressionReqDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOp();
            Integer $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            List<Object> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "ShuffleRuleReqDto.ExpressionReqDto(fieldName=" + this.getFieldName() + ", type=" + this.getType() + ", op=" + this.getOp() + ", value=" + this.getValue() + ", values=" + this.getValues() + ")";
        }

        public ExpressionReqDto(String fieldName, Integer type, int op, Object value, List<Object> values) {
            this.fieldName = fieldName;
            this.type = type;
            this.op = op;
            this.value = value;
            this.values = values;
        }

        public ExpressionReqDto() {
        }

        public static class ExpressionReqDtoBuilder {
            private String fieldName;
            private Integer type;
            private int op;
            private Object value;
            private List<Object> values;

            ExpressionReqDtoBuilder() {
            }

            public ExpressionReqDtoBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public ExpressionReqDtoBuilder type(Integer type) {
                this.type = type;
                return this;
            }

            public ExpressionReqDtoBuilder op(int op) {
                this.op = op;
                return this;
            }

            public ExpressionReqDtoBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public ExpressionReqDtoBuilder values(List<Object> values) {
                this.values = values;
                return this;
            }

            public ExpressionReqDto build() {
                return new ExpressionReqDto(this.fieldName, this.type, this.op, this.value, this.values);
            }

            public String toString() {
                return "ShuffleRuleReqDto.ExpressionReqDto.ExpressionReqDtoBuilder(fieldName=" + this.fieldName + ", type=" + this.type + ", op=" + this.op + ", value=" + this.value + ", values=" + this.values + ")";
            }
        }
    }

    @ApiModel(value="\u5206\u914d\u4eba\u5458")
    public static class AimDto {
        @ApiModelProperty(value="\u65e5\u671f")
        private List<Integer> days;
        @ApiModelProperty(value="\u7528\u6237")
        private List<String> userIds;
        @ApiModelProperty(value="\u90e8\u95e8")
        private List<String> deptIds;

        public void validate() {
            if (this.userIds == null) {
                this.userIds = Lists.newArrayList();
            }
            if (this.deptIds == null) {
                this.deptIds = Lists.newArrayList();
            }
        }

        public static AimDtoBuilder builder() {
            return new AimDtoBuilder();
        }

        public List<Integer> getDays() {
            return this.days;
        }

        public List<String> getUserIds() {
            return this.userIds;
        }

        public List<String> getDeptIds() {
            return this.deptIds;
        }

        public void setDays(List<Integer> days) {
            this.days = days;
        }

        public void setUserIds(List<String> userIds) {
            this.userIds = userIds;
        }

        public void setDeptIds(List<String> deptIds) {
            this.deptIds = deptIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AimDto)) {
                return false;
            }
            AimDto other = (AimDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$days = this.getDays();
            List<Integer> other$days = other.getDays();
            if (this$days == null ? other$days != null : !((Object)this$days).equals(other$days)) {
                return false;
            }
            List<String> this$userIds = this.getUserIds();
            List<String> other$userIds = other.getUserIds();
            if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
                return false;
            }
            List<String> this$deptIds = this.getDeptIds();
            List<String> other$deptIds = other.getDeptIds();
            return !(this$deptIds == null ? other$deptIds != null : !((Object)this$deptIds).equals(other$deptIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AimDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $days = this.getDays();
            result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
            List<String> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            List<String> $deptIds = this.getDeptIds();
            result = result * 59 + ($deptIds == null ? 43 : ((Object)$deptIds).hashCode());
            return result;
        }

        public String toString() {
            return "ShuffleRuleReqDto.AimDto(days=" + this.getDays() + ", userIds=" + this.getUserIds() + ", deptIds=" + this.getDeptIds() + ")";
        }

        public AimDto(List<Integer> days, List<String> userIds, List<String> deptIds) {
            this.days = days;
            this.userIds = userIds;
            this.deptIds = deptIds;
        }

        public AimDto() {
        }

        public static class AimDtoBuilder {
            private List<Integer> days;
            private List<String> userIds;
            private List<String> deptIds;

            AimDtoBuilder() {
            }

            public AimDtoBuilder days(List<Integer> days) {
                this.days = days;
                return this;
            }

            public AimDtoBuilder userIds(List<String> userIds) {
                this.userIds = userIds;
                return this;
            }

            public AimDtoBuilder deptIds(List<String> deptIds) {
                this.deptIds = deptIds;
                return this;
            }

            public AimDto build() {
                return new AimDto(this.days, this.userIds, this.deptIds);
            }

            public String toString() {
                return "ShuffleRuleReqDto.AimDto.AimDtoBuilder(days=" + this.days + ", userIds=" + this.userIds + ", deptIds=" + this.deptIds + ")";
            }
        }
    }
}

