/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.ad.dao.interceptor;

import cn.kinyun.ad.dao.annotations.MapF2A;
import cn.kinyun.ad.dao.annotations.MapF2F;
import cn.kinyun.ad.dao.annotations.MapF2L;
import cn.kinyun.ad.dao.annotations.MapF2M;
import cn.kinyun.ad.dao.annotations.MapF2ML;
import cn.kinyun.ad.dao.util.ReflectUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.springframework.dao.DuplicateKeyException;

@Intercepts(value={@Signature(method="handleResultSets", type=ResultSetHandler.class, args={Statement.class})})
public class MapF2Interceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        String currentMethodName;
        MetaObject metaStatementHandler = ReflectUtil.getRealTarget(invocation);
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("mappedStatement");
        String className = StringUtils.substringBeforeLast((String)mappedStatement.getId(), (String)".");
        Method currentMethod = this.findMethod(className, currentMethodName = StringUtils.substringAfterLast((String)mappedStatement.getId(), (String)"."));
        if (currentMethod != null) {
            if (currentMethod.getAnnotation(MapF2F.class) != null) {
                MapF2F mapF2FAnnotation = currentMethod.getAnnotation(MapF2F.class);
                Statement statement = (Statement)invocation.getArgs()[0];
                Pair<Class<?>, Class<?>> kvTypePair = this.getKVTypeOfReturnMapF2F(currentMethod);
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                return this.result2MapF2F(statement, typeHandlerRegistry, kvTypePair, mapF2FAnnotation);
            }
            if (currentMethod.getAnnotation(MapF2L.class) != null) {
                MapF2L mapF2LAnnotation = currentMethod.getAnnotation(MapF2L.class);
                Statement statement = (Statement)invocation.getArgs()[0];
                Pair<Class<?>, Class<?>> kvTypePair = this.getKVTypeOfReturnMapF2L(currentMethod);
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                return this.result2MapF2L(statement, typeHandlerRegistry, kvTypePair, mapF2LAnnotation);
            }
            if (currentMethod.getAnnotation(MapF2M.class) != null) {
                MapF2M mapF2MAnnotation = currentMethod.getAnnotation(MapF2M.class);
                Statement statement = (Statement)invocation.getArgs()[0];
                Pair<Class<?>, Pair<Class<?>, Class<?>>> kvTypePair = this.getKVTypeOfReturnMapF2M(currentMethod);
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                return this.result2MapF2M(statement, typeHandlerRegistry, kvTypePair, mapF2MAnnotation);
            }
            if (currentMethod.getAnnotation(MapF2ML.class) != null) {
                MapF2ML mapF2MLAnnotation = currentMethod.getAnnotation(MapF2ML.class);
                Statement statement = (Statement)invocation.getArgs()[0];
                Pair<Class<?>, Pair<Class<?>, Class<?>>> kvTypePair = this.getKVTypeOfReturnMapF2ML(currentMethod);
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                return this.result2MapF2ML(statement, typeHandlerRegistry, kvTypePair, mapF2MLAnnotation);
            }
            if (currentMethod.getAnnotation(MapF2A.class) != null) {
                MapF2A mapF2AAnnotation = currentMethod.getAnnotation(MapF2A.class);
                Statement statement = (Statement)invocation.getArgs()[0];
                Pair<Class<?>, Class<?>> kvTypePair = this.getKVTypeOfReturnMapF2L(currentMethod);
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                return this.result2MapF2A(statement, typeHandlerRegistry, kvTypePair, mapF2AAnnotation);
            }
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    public Object plugin(Object obj) {
        return Plugin.wrap((Object)obj, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Method findMethod(String className, String targetMethodName) throws Throwable {
        Method[] methods = Class.forName(className).getDeclaredMethods();
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)targetMethodName)) continue;
            return method;
        }
        return null;
    }

    private Pair<Class<?>, Class<?>> getKVTypeOfReturnMapF2F(Method mapF2FMethod) {
        Type returnType = mapF2FMethod.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (!Map.class.equals((Object)parameterizedType.getRawType())) {
                throw new RuntimeException("[ERROR-MapF2F-return-map-type]\u4f7f\u7528MapF2F,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2FMethod);
            }
            return Pair.of((Object)((Class)parameterizedType.getActualTypeArguments()[0]), (Object)((Class)parameterizedType.getActualTypeArguments()[1]));
        }
        return Pair.of(null, null);
    }

    private Pair<Class<?>, Class<?>> getKVTypeOfReturnMapF2L(Method mapF2LMethod) {
        Type returnType = mapF2LMethod.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (!Map.class.equals((Object)parameterizedType.getRawType())) {
                throw new RuntimeException("[ERROR-MapF2F-return-map-type]\u4f7f\u7528MapF2L,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,List<V>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2LMethod);
            }
            Type tmpType = parameterizedType.getActualTypeArguments()[1];
            if (tmpType instanceof ParameterizedType) {
                ParameterizedType tmpParameterizedType = (ParameterizedType)tmpType;
                if (!List.class.equals((Object)tmpParameterizedType.getRawType())) {
                    throw new RuntimeException("[ERROR-MapF2L-return-map-type]\u4f7f\u7528MapF2M,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,List<V>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2LMethod);
                }
                return Pair.of((Object)((Class)parameterizedType.getActualTypeArguments()[0]), (Object)((Class)tmpParameterizedType.getActualTypeArguments()[0]));
            }
            return Pair.of(null, null);
        }
        return Pair.of(null, null);
    }

    private Object result2MapF2F(Statement statement, TypeHandlerRegistry typeHandlerRegistry, Pair<Class<?>, Class<?>> kvTypePair, MapF2F mapF2FAnnotation) throws Throwable {
        ResultSet resultSet = statement.getResultSet();
        ArrayList res = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        while (resultSet.next()) {
            Object key = this.getObject(resultSet, 1, typeHandlerRegistry, (Class)kvTypePair.getKey());
            Object value = this.getObject(resultSet, 2, typeHandlerRegistry, (Class)kvTypePair.getValue());
            if (map.containsKey(key)) {
                if (!mapF2FAnnotation.isAllowKeyRepeat()) {
                    throw new DuplicateKeyException("MapF2F duplicated key!key=" + key);
                }
                Object preValue = map.get(key);
                if (!mapF2FAnnotation.isAllowValueDifferentWithSameKey() && !Objects.equals(value, preValue)) {
                    throw new DuplicateKeyException("MapF2F different value with same key!key=" + key + ",value1=" + preValue + ",value2=" + value);
                }
            }
            map.put(key, value);
        }
        res.add(map);
        return res;
    }

    private Pair<Class<?>, Pair<Class<?>, Class<?>>> getKVTypeOfReturnMapF2M(Method mapF2MMethod) {
        Type returnType = mapF2MMethod.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (!Map.class.equals((Object)parameterizedType.getRawType())) {
                throw new RuntimeException("[ERROR-MapF2L-return-map-type]\u4f7f\u7528MapF2M,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,Map<K,V>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2MMethod);
            }
            Type tmpType = parameterizedType.getActualTypeArguments()[1];
            if (tmpType instanceof ParameterizedType) {
                ParameterizedType tmpParameterizedType = (ParameterizedType)tmpType;
                if (!Map.class.equals((Object)tmpParameterizedType.getRawType())) {
                    throw new RuntimeException("[ERROR-MapF2L-return-map-type]\u4f7f\u7528MapF2M,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,Map<K,V>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2MMethod);
                }
                return Pair.of((Object)((Class)parameterizedType.getActualTypeArguments()[0]), (Object)Pair.of((Object)((Class)tmpParameterizedType.getActualTypeArguments()[0]), (Object)((Class)tmpParameterizedType.getActualTypeArguments()[1])));
            }
            return Pair.of(null, (Object)Pair.of(null, null));
        }
        return Pair.of(null, (Object)Pair.of(null, null));
    }

    private Pair<Class<?>, Pair<Class<?>, Class<?>>> getKVTypeOfReturnMapF2ML(Method mapF2MLMethod) {
        Type returnType = mapF2MLMethod.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (!Map.class.equals((Object)parameterizedType.getRawType())) {
                throw new RuntimeException("[ERROR-MapF2ML-return-map-type]\u4f7f\u7528MapF2ML,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,Map<K,List<V>>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2MLMethod);
            }
            Type tmpType = parameterizedType.getActualTypeArguments()[1];
            if (tmpType instanceof ParameterizedType) {
                ParameterizedType tmpParameterizedType = (ParameterizedType)tmpType;
                if (!Map.class.equals((Object)tmpParameterizedType.getRawType())) {
                    throw new RuntimeException("[ERROR-MapF2ML-return-map-type]\u4f7f\u7528MapF2ML,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,Map<K,List<V>>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2MLMethod);
                }
                Type tmp1Type = tmpParameterizedType.getActualTypeArguments()[1];
                if (tmp1Type instanceof ParameterizedType) {
                    ParameterizedType tmp1ParameterizedType = (ParameterizedType)tmp1Type;
                    if (!List.class.equals((Object)tmp1ParameterizedType.getRawType())) {
                        throw new RuntimeException("[ERROR-MapF2ML-return-map-type]\u4f7f\u7528MapF2ML,\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662fjava.util.Map<K,Map<K,List<V>>>\u7c7b\u578b\uff01\uff01\uff01method=" + mapF2MLMethod);
                    }
                    return Pair.of((Object)((Class)parameterizedType.getActualTypeArguments()[0]), (Object)Pair.of((Object)((Class)tmpParameterizedType.getActualTypeArguments()[0]), (Object)((Class)tmp1ParameterizedType.getActualTypeArguments()[0])));
                }
            }
        }
        return Pair.of(null, (Object)Pair.of(null, null));
    }

    private Object result2MapF2L(Statement statement, TypeHandlerRegistry typeHandlerRegistry, Pair<Class<?>, Class<?>> kvTypePair, MapF2L mapF2FAnnotation) throws Throwable {
        ResultSet resultSet = statement.getResultSet();
        ArrayList res = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        while (resultSet.next()) {
            Object key = this.getObject(resultSet, 1, typeHandlerRegistry, (Class)kvTypePair.getKey());
            Object value = this.getObject(resultSet, 2, typeHandlerRegistry, (Class)kvTypePair.getValue());
            List tmpList = map.getOrDefault(key, Lists.newArrayList());
            tmpList.add(value);
            map.put(key, tmpList);
        }
        res.add(map);
        return res;
    }

    private Object result2MapF2M(Statement statement, TypeHandlerRegistry typeHandlerRegistry, Pair<Class<?>, Pair<Class<?>, Class<?>>> kvTypePair, MapF2M mapF2FAnnotation) throws Throwable {
        ResultSet resultSet = statement.getResultSet();
        ArrayList res = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        while (resultSet.next()) {
            Object colum1 = this.getObject(resultSet, 1, typeHandlerRegistry, (Class)kvTypePair.getKey());
            Object colum2 = this.getObject(resultSet, 2, typeHandlerRegistry, (Class)((Pair)kvTypePair.getValue()).getKey());
            Object colum3 = this.getObject(resultSet, 3, typeHandlerRegistry, (Class)((Pair)kvTypePair.getValue()).getValue());
            Map tmpMap = map.getOrDefault(colum1, Maps.newHashMap());
            map.put(colum1, tmpMap);
            tmpMap.put(colum2, colum3);
        }
        res.add(map);
        return res;
    }

    private Object result2MapF2ML(Statement statement, TypeHandlerRegistry typeHandlerRegistry, Pair<Class<?>, Pair<Class<?>, Class<?>>> kvTypePair, MapF2ML mapF2MLAnnotation) throws Throwable {
        ResultSet resultSet = statement.getResultSet();
        ArrayList res = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        while (resultSet.next()) {
            Object colum1 = this.getObject(resultSet, 1, typeHandlerRegistry, (Class)kvTypePair.getKey());
            Object colum2 = this.getObject(resultSet, 2, typeHandlerRegistry, (Class)((Pair)kvTypePair.getValue()).getKey());
            Object colum3 = this.getObject(resultSet, 3, typeHandlerRegistry, (Class)((Pair)kvTypePair.getValue()).getValue());
            Map tmpMap = map.getOrDefault(colum1, Maps.newHashMap());
            List tmpList = tmpMap.getOrDefault(colum2, Lists.newArrayList());
            tmpList.add(colum3);
            map.put(colum1, tmpMap);
            tmpMap.put(colum2, tmpList);
        }
        res.add(map);
        return res;
    }

    private Object getObject(ResultSet resultSet, int columnIndex, TypeHandlerRegistry typeHandlerRegistry, Class<?> javaType) throws SQLException {
        TypeHandler typeHandler = typeHandlerRegistry.hasTypeHandler(javaType) ? typeHandlerRegistry.getTypeHandler(javaType) : typeHandlerRegistry.getUnknownTypeHandler();
        return typeHandler.getResult(resultSet, columnIndex);
    }

    private Object result2MapF2A(Statement statement, TypeHandlerRegistry typeHandlerRegistry, Pair<Class<?>, Class<?>> kvTypePair, MapF2A mapF2AAnnotation) throws Throwable {
        ResultSet resultSet = statement.getResultSet();
        ArrayList res = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        while (resultSet.next()) {
            Object key = this.getObject(resultSet, 1, typeHandlerRegistry, (Class)kvTypePair.getKey());
            Object value1 = this.getObject(resultSet, 2, typeHandlerRegistry, (Class)kvTypePair.getValue());
            Object value2 = this.getObject(resultSet, 3, typeHandlerRegistry, (Class)kvTypePair.getValue());
            List tmpList = map.getOrDefault(key, Lists.newArrayList());
            tmpList.add(value1);
            tmpList.add(value2);
            map.put(key, tmpList);
        }
        res.add(map);
        return res;
    }
}

