/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.builder;

import cn.idev.excel.ExcelWriter;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.write.builder.AbstractExcelWriterParameterBuilder;
import cn.idev.excel.write.builder.CsvWriterBuilder;
import cn.idev.excel.write.builder.ExcelWriterSheetBuilder;
import cn.idev.excel.write.metadata.WriteWorkbook;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class ExcelWriterBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterBuilder, WriteWorkbook> {
    private final WriteWorkbook writeWorkbook = new WriteWorkbook();

    public ExcelWriterBuilder autoCloseStream(Boolean autoCloseStream) {
        this.writeWorkbook.setAutoCloseStream(autoCloseStream);
        return this;
    }

    public ExcelWriterBuilder password(String password) {
        this.writeWorkbook.setPassword(password);
        return this;
    }

    public ExcelWriterBuilder inMemory(Boolean inMemory) {
        this.writeWorkbook.setInMemory(inMemory);
        return this;
    }

    public ExcelWriterBuilder writeExcelOnException(Boolean writeExcelOnException) {
        this.writeWorkbook.setWriteExcelOnException(writeExcelOnException);
        return this;
    }

    public ExcelWriterBuilder excelType(ExcelTypeEnum excelType) {
        this.writeWorkbook.setExcelType(excelType);
        return this;
    }

    public ExcelWriterBuilder file(OutputStream outputStream) {
        this.writeWorkbook.setOutputStream(outputStream);
        return this;
    }

    public ExcelWriterBuilder file(File outputFile) {
        this.writeWorkbook.setFile(outputFile);
        return this;
    }

    public ExcelWriterBuilder file(String outputPathName) {
        return this.file(new File(outputPathName));
    }

    public ExcelWriterBuilder charset(Charset charset) {
        this.writeWorkbook.setCharset(charset);
        return this;
    }

    public ExcelWriterBuilder withBom(Boolean withBom) {
        this.writeWorkbook.setWithBom(withBom);
        return this;
    }

    public ExcelWriterBuilder withTemplate(InputStream templateInputStream) {
        this.writeWorkbook.setTemplateInputStream(templateInputStream);
        return this;
    }

    public ExcelWriterBuilder withTemplate(File templateFile) {
        this.writeWorkbook.setTemplateFile(templateFile);
        return this;
    }

    public ExcelWriterBuilder withTemplate(String pathName) {
        return this.withTemplate(new File(pathName));
    }

    public ExcelWriter build() {
        return new ExcelWriter(this.writeWorkbook);
    }

    public ExcelWriterSheetBuilder sheet() {
        return this.sheet(null, null);
    }

    public ExcelWriterSheetBuilder sheet(Integer sheetNo) {
        return this.sheet(sheetNo, null);
    }

    public ExcelWriterSheetBuilder sheet(String sheetName) {
        return this.sheet(null, sheetName);
    }

    public ExcelWriterSheetBuilder sheet(Integer sheetNo, String sheetName) {
        ExcelWriter excelWriter = this.build();
        ExcelWriterSheetBuilder excelWriterSheetBuilder = new ExcelWriterSheetBuilder(excelWriter);
        if (sheetNo != null) {
            excelWriterSheetBuilder.sheetNo(sheetNo);
        }
        if (sheetName != null) {
            excelWriterSheetBuilder.sheetName(sheetName);
        }
        return excelWriterSheetBuilder;
    }

    public CsvWriterBuilder csv() {
        this.excelType(ExcelTypeEnum.CSV);
        return new CsvWriterBuilder(this.parameter());
    }

    @Override
    protected WriteWorkbook parameter() {
        return this.writeWorkbook;
    }
}

