/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.runner.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.Sets;
import org.jetlinks.zlmedia.restful.ZLMediaConfigs;
import org.jetlinks.zlmedia.runner.process.ProcessZLMediaRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.StreamUtils;
import org.springframework.web.reactive.function.client.WebClient;

public class EmbeddedProcessMediaRuntime
extends ProcessZLMediaRuntime {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedProcessMediaRuntime.class);
    private static final Map<String, String> installed = new ConcurrentHashMap<String, String>();

    public EmbeddedProcessMediaRuntime(String workdir) {
        this(workdir, new ZLMediaConfigs());
    }

    public EmbeddedProcessMediaRuntime(String workdir, ZLMediaConfigs configs) {
        super(EmbeddedProcessMediaRuntime.install(workdir), configs);
    }

    public EmbeddedProcessMediaRuntime(String workdir, WebClient.Builder builder, ObjectMapper mapper, ZLMediaConfigs configs) {
        super(EmbeddedProcessMediaRuntime.install(workdir), builder, mapper, configs);
    }

    static String install(String workdir) {
        return installed.computeIfAbsent(workdir, dir -> EmbeddedProcessMediaRuntime.install("zlmedia-native/" + PlatformDependent.normalizedOs() + "/" + PlatformDependent.normalizedArch() + ".zip", workdir));
    }

    private static String install(String file, String workdir) {
        String mediaServer = null;
        try {
            FileSystemResource resource = new FileSystemResource(file);
            if (!resource.exists()) {
                resource = new ClassPathResource(file);
            }
            log.debug("install ZLMediaKit to {}", (Object)workdir);
            try (InputStream stream = resource.getInputStream();
                 ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);){
                ZipArchiveEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    Path copyTo;
                    File copyToFile;
                    String filename;
                    if (entry.isDirectory() || (filename = entry.getName()).contains(" __MACOSX") || filename.endsWith(".DS_Store") || filename.endsWith("/") || (copyToFile = (copyTo = Paths.get(workdir, filename)).toFile()).isDirectory()) continue;
                    boolean ignore = copyToFile.getParentFile().mkdirs();
                    log.debug("copy {} to {}", (Object)filename, (Object)copyTo);
                    try (OutputStream output = Files.newOutputStream(copyTo, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                        StreamUtils.copy((InputStream)zip, (OutputStream)output);
                    }
                    String _fileName = copyToFile.getName();
                    if (_fileName.equals("MediaServer") || _fileName.equals("MediaServer.exe")) {
                        mediaServer = copyTo.toString();
                    }
                    EmbeddedProcessMediaRuntime.chmodX(copyTo);
                }
            }
        }
        catch (Throwable e) {
            log.error("install ZLMediaKit error", e);
            throw e;
        }
        if (mediaServer == null) {
            throw new IllegalAccessException("No process file 'MediaServer' found in:" + workdir);
        }
        ClassPathResource config = new ClassPathResource("zlmedia-native/config.ini");
        try (InputStream input = config.getInputStream();
             OutputStream output = Files.newOutputStream(Paths.get(mediaServer, new String[0]).getParent().resolve("config.ini"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            StreamUtils.copy((InputStream)input, (OutputStream)output);
        }
        return mediaServer;
    }

    private static void chmodX(Path file) {
        if (PlatformDependent.isWindows()) {
            return;
        }
        try {
            PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            view.setPermissions(Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ}));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

