/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.List;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.defaults.AbstractOutput;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class EventBusOutput
extends AbstractOutput {
    private static final Logger log = LoggerFactory.getLogger(EventBusOutput.class);
    private final EventBus eventBus;

    public EventBusOutput(String instanceId, EventBus eventBus, List<ScheduleJob.Output> outputs, ConditionEvaluator evaluator) {
        super(instanceId, outputs, evaluator);
        this.eventBus = eventBus;
    }

    @Override
    protected Mono<Boolean> doWrite(CharSequence address, Publisher<RuleData> data) {
        return this.eventBus.publish(address, data).then(Reactors.ALWAYS_TRUE);
    }

    @Override
    protected Mono<Boolean> doWrite(CharSequence address, RuleData data) {
        return this.eventBus.publish(address, (Object)data).then(Reactors.ALWAYS_TRUE);
    }
}

