/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.io.OutputStream;
import java.util.function.Consumer;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.spec.DefaultWriterSepc;
import org.hswebframework.reactor.excel.spec.SheetSpec;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.hswebframework.reactor.excel.utils.StreamUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WriterSpec {
    public Mono<Void> write(OutputStream var1);

    default public Flux<byte[]> writeBytes(int bufferSize) {
        return StreamUtils.buffer(bufferSize, this::write);
    }

    public WriterSpec option(ExcelOption ... var1);

    public static WriterSpecSelector writeFor(ExcelWriter writer) {
        return new DefaultWriterSepc(writer.isSupportMultiSheet() ? Integer.MAX_VALUE : 1, writer);
    }

    public static SheetWriterSpec single(ExcelWriter writer) {
        return new DefaultWriterSepc(1, writer);
    }

    public static MultiSheetWriterSpec multi(ExcelWriter writer) {
        return new DefaultWriterSepc(writer.isSupportMultiSheet() ? Integer.MAX_VALUE : 1, writer);
    }

    public static interface MultiSheetWriterSpec
    extends SheetWriterSpec {
        public MultiSheetWriterSpec sheet(int var1, Consumer<SheetSpec.HeaderSheetSpec> var2);

        public MultiSheetWriterSpec cellSheet(int var1, Consumer<SheetSpec.CellSheetSpec> var2);

        @Override
        public MultiSheetWriterSpec option(ExcelOption ... var1);
    }

    public static interface SheetWriterSpec
    extends WriterSpec {
        public SheetWriterSpec sheet(Consumer<SheetSpec.HeaderSheetSpec> var1);

        public SheetWriterSpec cellSheet(Consumer<SheetSpec.CellSheetSpec> var1);

        @Override
        public SheetWriterSpec option(ExcelOption ... var1);
    }

    public static interface WriterSpecSelector {
        public SheetWriterSpec justWrite();

        public MultiSheetWriterSpec multiSheet();
    }
}

