/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.converter.MapRowExpander;
import org.hswebframework.reactor.excel.poi.options.SheetOption;
import org.hswebframework.reactor.excel.spec.SheetSpec;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class DefaultSheetSpec
implements SheetSpec.HeaderSheetSpec,
SheetSpec {
    private final MapRowExpander expander;
    private long firstRowIndex = 0L;
    private Flux<Cell> cells = Flux.empty();
    private final List<Cell> fixedCells = new ArrayList<Cell>();
    private Flux<Map<String, Object>> rows = Flux.empty();
    private final List<SheetOption> options = new ArrayList<SheetOption>();
    private String name;

    public DefaultSheetSpec(int sheetIndex) {
        this.expander = new MapRowExpander(sheetIndex);
    }

    @Override
    public SheetSpec.CellSheetSpec cells(Flux<Cell> cells) {
        this.cells = Flux.concat((Publisher[])new Publisher[]{this.cells, cells});
        return this;
    }

    @Override
    public SheetSpec.CellSheetSpec cells(Iterable<Cell> cells) {
        for (Cell cell : cells) {
            this.fixedCells.add(cell);
        }
        return this;
    }

    @Override
    public SheetSpec.CellSheetSpec cell(Cell cell) {
        this.fixedCells.add(cell);
        return this;
    }

    @Override
    public DefaultSheetSpec name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DefaultSheetSpec rows(Flux<Map<String, Object>> rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public DefaultSheetSpec firstRowIndex(int index) {
        this.firstRowIndex = index;
        return this;
    }

    @Override
    public DefaultSheetSpec header(String key, String header) {
        this.expander.header(key, header);
        return this;
    }

    @Override
    public DefaultSheetSpec header(ExcelHeader header) {
        this.expander.header(header);
        return this;
    }

    @Override
    public DefaultSheetSpec headers(Collection<ExcelHeader> headers) {
        this.expander.headers(headers);
        return this;
    }

    @Override
    public DefaultSheetSpec handle(Consumer<SheetSpec.HeaderSheetSpec> handler) {
        handler.accept(this);
        return this;
    }

    @Override
    public DefaultSheetSpec option(SheetOption ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    List<SheetOption> getOptions() {
        return this.options;
    }

    Flux<Cell> cells() {
        this.fixedCells.sort(Comparator.comparingLong(Cell::getRowIndex));
        return Flux.concat((Publisher[])new Publisher[]{this.expander.headers(this.firstRowIndex), Flux.fromIterable(this.fixedCells), this.rows.index().concatMap(idx -> this.expander.apply((Long)idx.getT1() + this.firstRowIndex + 1L, (Map)idx.getT2())), this.cells});
    }

    public String getName() {
        return this.name;
    }
}

