/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.rsocket.SocketAcceptor;
import io.rsocket.core.RSocketServer;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.scalecube.net.Address;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import io.scalecube.services.transport.api.ServerTransport;
import io.scalecube.services.transport.rsocket.ConnectionSetupCodec;
import io.scalecube.services.transport.rsocket.RSocketServerTransportFactory;
import io.scalecube.services.transport.rsocket.RSocketServiceAcceptor;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RSocketServerTransport
implements ServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSocketServerTransport.class);
    private final Authenticator<Object> authenticator;
    private final ServiceMethodRegistry methodRegistry;
    private final ConnectionSetupCodec connectionSetupCodec;
    private final HeadersCodec headersCodec;
    private final Collection<DataCodec> dataCodecs;
    private final RSocketServerTransportFactory serverTransportFactory;
    private CloseableChannel serverChannel;

    public RSocketServerTransport(Authenticator<Object> authenticator, ServiceMethodRegistry methodRegistry, ConnectionSetupCodec connectionSetupCodec, HeadersCodec headersCodec, Collection<DataCodec> dataCodecs, RSocketServerTransportFactory serverTransportFactory) {
        this.authenticator = authenticator;
        this.methodRegistry = methodRegistry;
        this.connectionSetupCodec = connectionSetupCodec;
        this.headersCodec = headersCodec;
        this.dataCodecs = dataCodecs;
        this.serverTransportFactory = serverTransportFactory;
    }

    public Address address() {
        InetSocketAddress socketAddress = this.serverChannel.address();
        return Address.create((String)socketAddress.getAddress().getHostAddress(), (int)socketAddress.getPort());
    }

    public Mono<ServerTransport> bind() {
        return Mono.defer(() -> RSocketServer.create().acceptor((SocketAcceptor)new RSocketServiceAcceptor(this.connectionSetupCodec, this.headersCodec, this.dataCodecs, this.authenticator, this.methodRegistry)).payloadDecoder(PayloadDecoder.DEFAULT).bind(this.serverTransportFactory.serverTransport()).doOnSuccess(channel -> {
            this.serverChannel = channel;
        }).thenReturn((Object)this));
    }

    public Mono<Void> stop() {
        return Mono.defer(() -> {
            if (this.serverChannel == null || this.serverChannel.isDisposed()) {
                return Mono.empty();
            }
            return Mono.fromRunnable(() -> this.serverChannel.dispose()).then(this.serverChannel.onClose().doOnError(e -> LOGGER.warn("[rsocket][server][onClose] Exception occurred: {}", (Object)e.toString())));
        });
    }
}

