/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.ChannelOption;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import io.scalecube.net.Address;
import java.util.function.Function;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;

public interface RSocketClientTransportFactory {
    public static Function<LoopResources, RSocketClientTransportFactory> tcp() {
        return RSocketClientTransportFactory.tcp(false);
    }

    public static Function<LoopResources, RSocketClientTransportFactory> tcp(boolean isSecured) {
        return loopResources -> address -> {
            TcpClient tcpClient = TcpClient.newConnection().runOn(loopResources).host(address.host()).port(address.port()).option(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true);
            return TcpClientTransport.create((TcpClient)(isSecured ? tcpClient.secure() : tcpClient));
        };
    }

    public static Function<LoopResources, RSocketClientTransportFactory> websocket() {
        return RSocketClientTransportFactory.websocket(false);
    }

    public static Function<LoopResources, RSocketClientTransportFactory> websocket(boolean isSecured) {
        return loopResources -> address -> {
            HttpClient httpClient = (HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)ConnectionProvider.newConnection()).runOn(loopResources)).host(address.host())).port(address.port()).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true);
            httpClient = isSecured ? httpClient.secure() : httpClient;
            return WebsocketClientTransport.create((HttpClient)httpClient, (String)"/");
        };
    }

    public ClientTransport clientTransport(Address var1);
}

