/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.StringMapSchema;
import io.protostuff.runtime.RuntimeSchema;
import io.scalecube.services.exceptions.MessageCodecException;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class ProtostuffCodec
implements HeadersCodec,
DataCodec {
    public static final String CONTENT_TYPE = "application/protostuff";

    public String contentType() {
        return CONTENT_TYPE;
    }

    public void encode(OutputStream stream, Object value) throws IOException {
        Schema schema = RuntimeSchema.getSchema(value.getClass());
        ProtobufIOUtil.writeTo((OutputStream)stream, (Object)value, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate());
    }

    public void encode(OutputStream stream, Map<String, String> headers) throws IOException {
        ProtostuffIOUtil.writeTo((OutputStream)stream, headers, (Schema)StringMapSchema.VALUE_STRING, (LinkedBuffer)LinkedBuffer.allocate());
    }

    public Object decode(InputStream stream, Type type) throws IOException {
        try {
            Class<?> clazz = null;
            if (type instanceof Class) {
                clazz = (Class<?>)type;
            } else if (type instanceof ParameterizedType) {
                clazz = Class.forName(((ParameterizedType)type).getRawType().getTypeName());
            }
            Schema schema = RuntimeSchema.getSchema((Class)clazz);
            Object result = schema.newMessage();
            ProtobufIOUtil.mergeFrom((InputStream)stream, (Object)result, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate());
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new MessageCodecException("Couldn't decode message", (Throwable)e);
        }
    }

    public Map<String, String> decode(InputStream stream) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        ProtostuffIOUtil.mergeFrom((InputStream)stream, map, (Schema)StringMapSchema.VALUE_STRING, (LinkedBuffer)LinkedBuffer.allocate());
        return map;
    }
}

