/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.fdetector.FailureDetectorConfig;
import io.scalecube.cluster.gossip.GossipConfig;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.transport.api.TransportConfig;
import io.scalecube.reactor.RetryNonSerializedEmitFailureHandler;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.discovery.api.ServiceDiscoveryContext;
import io.scalecube.services.discovery.api.ServiceDiscoveryEvent;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public final class ScalecubeServiceDiscovery
implements ServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceDiscovery.class);
    private ClusterConfig clusterConfig;
    private Cluster cluster;
    private final Sinks.Many<ServiceDiscoveryEvent> sink = Sinks.many().multicast().directBestEffort();

    public ScalecubeServiceDiscovery() {
        this.clusterConfig = ClusterConfig.defaultLanConfig();
    }

    private ScalecubeServiceDiscovery(ScalecubeServiceDiscovery other) {
        this.clusterConfig = other.clusterConfig;
        this.cluster = other.cluster;
    }

    public ScalecubeServiceDiscovery options(UnaryOperator<ClusterConfig> opts) {
        ScalecubeServiceDiscovery d = new ScalecubeServiceDiscovery(this);
        d.clusterConfig = (ClusterConfig)opts.apply(this.clusterConfig);
        return d;
    }

    public ScalecubeServiceDiscovery transport(UnaryOperator<TransportConfig> opts) {
        return this.options(cfg -> cfg.transport(opts));
    }

    public ScalecubeServiceDiscovery membership(UnaryOperator<MembershipConfig> opts) {
        return this.options(cfg -> cfg.membership(opts));
    }

    public ScalecubeServiceDiscovery gossip(UnaryOperator<GossipConfig> opts) {
        return this.options(cfg -> cfg.gossip(opts));
    }

    public ScalecubeServiceDiscovery failureDetector(UnaryOperator<FailureDetectorConfig> opts) {
        return this.options(cfg -> cfg.failureDetector(opts));
    }

    public Mono<Void> start() {
        return Mono.deferContextual(context -> {
            ServiceDiscoveryContext.Builder discoveryContextBuilder = (ServiceDiscoveryContext.Builder)context.get(ServiceDiscoveryContext.Builder.class);
            return new ClusterImpl().config(options -> this.clusterConfig).handler(cluster -> new ClusterMessageHandler(){

                public void onMembershipEvent(MembershipEvent event) {
                    ScalecubeServiceDiscovery.this.onMembershipEvent(event);
                }
            }).start().doOnSuccess(cluster -> {
                this.cluster = cluster;
                discoveryContextBuilder.address(this.cluster.address());
            }).then(Mono.fromCallable(() -> JmxMonitorMBean.start(this))).then();
        });
    }

    public Flux<ServiceDiscoveryEvent> listen() {
        return this.sink.asFlux().onBackpressureBuffer();
    }

    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            if (this.cluster == null) {
                this.sink.emitComplete((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
                return Mono.empty();
            }
            this.cluster.shutdown();
            return this.cluster.onShutdown().doFinally(s -> this.sink.emitComplete((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED));
        });
    }

    private void onMembershipEvent(MembershipEvent membershipEvent) {
        LOGGER.debug("onMembershipEvent: {}", (Object)membershipEvent);
        ServiceDiscoveryEvent discoveryEvent = this.toServiceDiscoveryEvent(membershipEvent);
        if (discoveryEvent == null) {
            LOGGER.warn("DiscoveryEvent is null, cannot publish it (corresponding membershipEvent: {})", (Object)membershipEvent);
            return;
        }
        if (discoveryEvent != null) {
            LOGGER.debug("Publish discoveryEvent: {}", (Object)discoveryEvent);
            this.sink.emitNext((Object)discoveryEvent, (Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
        }
    }

    private ServiceDiscoveryEvent toServiceDiscoveryEvent(MembershipEvent membershipEvent) {
        ServiceDiscoveryEvent discoveryEvent = null;
        if (membershipEvent.isAdded() && membershipEvent.newMetadata() != null) {
            discoveryEvent = ServiceDiscoveryEvent.newEndpointAdded((ServiceEndpoint)this.decodeMetadata(membershipEvent.newMetadata()));
        }
        if (membershipEvent.isRemoved() && membershipEvent.oldMetadata() != null) {
            discoveryEvent = ServiceDiscoveryEvent.newEndpointRemoved((ServiceEndpoint)this.decodeMetadata(membershipEvent.oldMetadata()));
        }
        if (membershipEvent.isLeaving() && membershipEvent.newMetadata() != null) {
            discoveryEvent = ServiceDiscoveryEvent.newEndpointLeaving((ServiceEndpoint)this.decodeMetadata(membershipEvent.newMetadata()));
        }
        return discoveryEvent;
    }

    private ServiceEndpoint decodeMetadata(ByteBuffer byteBuffer) {
        try {
            return (ServiceEndpoint)this.clusterConfig.metadataCodec().deserialize(byteBuffer.duplicate());
        }
        catch (Exception e) {
            LOGGER.error("Failed to read metadata: " + e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ScalecubeServiceDiscovery.class.getSimpleName() + "[", "]").add("cluster=" + this.cluster).add("clusterConfig=" + this.clusterConfig).toString();
    }

    private static class JmxMonitorMBean
    implements MonitorMBean {
        private static final String OBJECT_NAME_FORMAT = "io.scalecube.services.discovery:name=%s@%s";
        public static final int RECENT_DISCOVERY_EVENTS_SIZE = 128;
        private final ScalecubeServiceDiscovery discovery;
        private final List<ServiceDiscoveryEvent> recentDiscoveryEvents = new CopyOnWriteArrayList<ServiceDiscoveryEvent>();

        private JmxMonitorMBean(ScalecubeServiceDiscovery discovery) {
            this.discovery = discovery;
        }

        private static JmxMonitorMBean start(ScalecubeServiceDiscovery instance) throws Exception {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            JmxMonitorMBean jmxMBean = new JmxMonitorMBean(instance);
            jmxMBean.init();
            ObjectName objectName = new ObjectName(String.format(OBJECT_NAME_FORMAT, instance.cluster.member().id(), System.nanoTime()));
            StandardMBean standardMBean = new StandardMBean(jmxMBean, MonitorMBean.class);
            mbeanServer.registerMBean(standardMBean, objectName);
            return jmxMBean;
        }

        private void init() {
            this.discovery.listen().subscribe(this::onDiscoveryEvent);
        }

        @Override
        public String getClusterConfig() {
            return String.valueOf(this.discovery.clusterConfig);
        }

        @Override
        public String getRecentDiscoveryEvents() {
            return this.recentDiscoveryEvents.stream().map(ServiceDiscoveryEvent::toString).collect(Collectors.joining(",", "[", "]"));
        }

        private void onDiscoveryEvent(ServiceDiscoveryEvent event) {
            this.recentDiscoveryEvents.add(event);
            if (this.recentDiscoveryEvents.size() > 128) {
                this.recentDiscoveryEvents.remove(0);
            }
        }
    }

    public static interface MonitorMBean {
        public String getClusterConfig();

        public String getRecentDiscoveryEvents();
    }
}

