/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.api.Qualifier;
import java.lang.reflect.Type;
import java.util.StringJoiner;

public final class MethodInfo {
    private final String serviceName;
    private final String methodName;
    private final String qualifier;
    private final Type parameterizedReturnType;
    private final boolean isReturnTypeServiceMessage;
    private final CommunicationMode communicationMode;
    private final int parameterCount;
    private final Class<?> requestType;
    private final boolean isRequestTypeServiceMessage;
    private final boolean isSecured;

    public MethodInfo(String serviceName, String methodName, Type parameterizedReturnType, boolean isReturnTypeServiceMessage, CommunicationMode communicationMode, int parameterCount, Class<?> requestType, boolean isRequestTypeServiceMessage, boolean isSecured) {
        this.parameterizedReturnType = parameterizedReturnType;
        this.isReturnTypeServiceMessage = isReturnTypeServiceMessage;
        this.communicationMode = communicationMode;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.qualifier = Qualifier.asString(serviceName, methodName);
        this.parameterCount = parameterCount;
        this.requestType = requestType;
        this.isRequestTypeServiceMessage = isRequestTypeServiceMessage;
        this.isSecured = isSecured;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String methodName() {
        return this.methodName;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String oldQualifier() {
        return "/" + this.qualifier();
    }

    public Type parameterizedReturnType() {
        return this.parameterizedReturnType;
    }

    public boolean isReturnTypeServiceMessage() {
        return this.isReturnTypeServiceMessage;
    }

    public CommunicationMode communicationMode() {
        return this.communicationMode;
    }

    public int parameterCount() {
        return this.parameterCount;
    }

    public boolean isRequestTypeServiceMessage() {
        return this.isRequestTypeServiceMessage;
    }

    public boolean isRequestTypeVoid() {
        return this.requestType.isAssignableFrom(Void.TYPE);
    }

    public Class<?> requestType() {
        return this.requestType;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public String toString() {
        return new StringJoiner(", ", MethodInfo.class.getSimpleName() + "[", "]").add("serviceName=" + this.serviceName).add("methodName=" + this.methodName).add("qualifier=" + this.qualifier).add("parameterizedReturnType=" + this.parameterizedReturnType).add("isReturnTypeServiceMessage=" + this.isReturnTypeServiceMessage).add("communicationMode=" + (Object)((Object)this.communicationMode)).add("parameterCount=" + this.parameterCount).add("requestType=" + this.requestType).add("isRequestTypeServiceMessage=" + this.isRequestTypeServiceMessage).add("isSecured=" + this.isSecured).toString();
    }
}

