/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery.api;

import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.discovery.api.ServiceDiscoveryFactory;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;

public final class ServiceDiscoveryOptions {
    private String id = UUID.randomUUID().toString();
    private ServiceEndpoint serviceEndpoint;
    private ServiceDiscoveryFactory discoveryFactory;

    public ServiceDiscoveryOptions() {
    }

    public ServiceDiscoveryOptions(ServiceDiscoveryOptions other) {
        this.id = other.id;
        this.serviceEndpoint = other.serviceEndpoint;
        this.discoveryFactory = other.discoveryFactory;
    }

    private ServiceDiscoveryOptions set(Consumer<ServiceDiscoveryOptions> c) {
        ServiceDiscoveryOptions s = new ServiceDiscoveryOptions(this);
        c.accept(s);
        return s;
    }

    public ServiceDiscoveryOptions id(String id) {
        return this.set(o -> {
            o.id = id;
        });
    }

    public String id() {
        return this.id;
    }

    public ServiceDiscoveryOptions serviceEndpoint(ServiceEndpoint serviceEndpoint) {
        return this.set(o -> {
            o.serviceEndpoint = serviceEndpoint;
        });
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public ServiceDiscoveryOptions discoveryFactory(ServiceDiscoveryFactory discoveryFactory) {
        return this.set(o -> {
            o.discoveryFactory = discoveryFactory;
        });
    }

    public ServiceDiscoveryFactory discoveryFactory() {
        return this.discoveryFactory;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceDiscoveryOptions.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("serviceEndpoint=" + this.serviceEndpoint).add("discoveryFactory=" + this.discoveryFactory).toString();
    }
}

