/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.ServiceMethodDefinition;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ServiceRegistration
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String namespace;
    private Map<String, String> tags;
    private Collection<ServiceMethodDefinition> methods;

    @Deprecated
    public ServiceRegistration() {
    }

    public ServiceRegistration(String namespace, Map<String, String> tags, Collection<ServiceMethodDefinition> methods) {
        this.namespace = Objects.requireNonNull(namespace, "ServiceRegistration.namespace is required");
        this.tags = Collections.unmodifiableMap(new HashMap<String, String>(tags));
        this.methods = Collections.unmodifiableList(new ArrayList<ServiceMethodDefinition>(methods));
    }

    public String namespace() {
        return this.namespace;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Collection<ServiceMethodDefinition> methods() {
        return this.methods;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceRegistration.class.getSimpleName() + "[", "]").add("namespace=" + this.namespace).add("tags=" + this.tags).add("methods(" + this.methods.size() + ")").toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.namespace);
        out.writeInt(this.tags.size());
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.methods.size());
        for (ServiceMethodDefinition method : this.methods) {
            out.writeObject(method);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.namespace = in.readUTF();
        int tagsSize = in.readInt();
        HashMap<String, String> tags = new HashMap<String, String>(tagsSize);
        for (int i = 0; i < tagsSize; ++i) {
            String key = in.readUTF();
            String value = (String)in.readObject();
            tags.put(key, value);
        }
        this.tags = Collections.unmodifiableMap(tags);
        int methodsSize = in.readInt();
        ArrayList<ServiceMethodDefinition> methods = new ArrayList<ServiceMethodDefinition>(methodsSize);
        for (int i = 0; i < methodsSize; ++i) {
            methods.add((ServiceMethodDefinition)in.readObject());
        }
        this.methods = Collections.unmodifiableList(methods);
    }
}

