/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;

public class ReturnStatus
extends AbstractDataToken {
    private static final ReturnStatus[] CACHED = new ReturnStatus[128];
    public static final byte TYPE = 121;
    private final int status;

    private ReturnStatus(int status) {
        super((byte)121);
        this.status = status;
    }

    public static ReturnStatus create(int status) {
        if (status >= 0 && status < CACHED.length) {
            return CACHED[status];
        }
        return new ReturnStatus(status);
    }

    public static ReturnStatus decode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        return ReturnStatus.create(Decode.asLong(buffer));
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        return buffer.readableBytes() >= 5;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public byte getType() {
        return 121;
    }

    @Override
    public String getName() {
        return "RETURNSTATUS";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [status=").append(this.status);
        sb.append(']');
        return sb.toString();
    }

    static {
        for (int i = 0; i < CACHED.length; ++i) {
            ReturnStatus.CACHED[i] = new ReturnStatus(i);
        }
    }
}

