/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Version;

public class LoginAckToken
extends AbstractDataToken {
    public static final byte TYPE = -83;
    public static final byte CLIENT_INTEFACE_DEFAULT = 0;
    public static final byte CLIENT_INTEFACE_TSQL = 1;
    private final long length;
    private final byte clientInterface;
    private final int tdsVersion;
    private final String progrName;
    private final Version version;

    public LoginAckToken(long length, byte clientInterface, int tdsVersion, String progrName, Version version) {
        super((byte)-83);
        this.length = length;
        this.clientInterface = clientInterface;
        this.tdsVersion = tdsVersion;
        this.progrName = progrName;
        this.version = version;
    }

    public static LoginAckToken decode(ByteBuf buffer) {
        int length = Decode.uShort(buffer);
        byte clientInterface = Decode.asByte(buffer);
        int tdsVersion = Decode.intBigEndian(buffer);
        String progName = Decode.unicodeBString(buffer);
        byte major = Decode.asByte(buffer);
        byte minor = Decode.asByte(buffer);
        short build = buffer.readShort();
        Version serverVersion = new Version(major, minor, build);
        return new LoginAckToken(length, clientInterface, tdsVersion, progName, serverVersion);
    }

    public byte getClientInterface() {
        return this.clientInterface;
    }

    public int getTdsVersion() {
        return this.tdsVersion;
    }

    public String getProgrName() {
        return this.progrName;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return "LOGINACK";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [clientInterface=").append(this.clientInterface);
        sb.append(", tdsVersion=").append(this.tdsVersion);
        sb.append(", progrName='").append(this.progrName).append('\"');
        sb.append(", version=").append(this.version);
        sb.append(']');
        return sb.toString();
    }
}

