/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.List;

public final class FeatureExtAckToken
extends AbstractDataToken {
    public static final byte TYPE = -82;
    public static final byte TERMINATOR = -1;
    private final List<FeatureToken> featureTokens;

    private FeatureExtAckToken(List<FeatureToken> featureTokens) {
        super((byte)-82);
        this.featureTokens = featureTokens;
    }

    public static FeatureExtAckToken decode(ByteBuf buffer) {
        byte featureId;
        Assert.requireNonNull(buffer, "Buffer must not be null");
        ArrayList<FeatureToken> featureTokens = new ArrayList<FeatureToken>();
        while ((featureId = buffer.readByte()) != -1) {
            if (featureId == 4) {
                featureTokens.add(ColumnEncryption.decode(buffer));
                continue;
            }
            featureTokens.add(UnknownFeature.decode(featureId, buffer));
        }
        return new FeatureExtAckToken(featureTokens);
    }

    public List<FeatureToken> getFeatureTokens() {
        return this.featureTokens;
    }

    @Override
    public String getName() {
        return "FEATUREEXTACK";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [featureTokens=").append(this.featureTokens);
        sb.append(']');
        return sb.toString();
    }

    public static final class UnknownFeature
    extends FeatureToken {
        private final byte[] data;

        public UnknownFeature(byte featureId, long length, byte[] data) {
            super(featureId, length);
            this.data = data;
        }

        public static UnknownFeature decode(byte featureId, ByteBuf buffer) {
            Assert.requireNonNull(buffer, "Buffer must not be null");
            long length = Decode.dword(buffer);
            byte[] bytes = new byte[Math.toIntExact(length)];
            buffer.readBytes(bytes);
            return new UnknownFeature(featureId, length, bytes);
        }
    }

    public static final class ColumnEncryption
    extends FeatureToken {
        public static final byte FEATURE_ID = 4;
        private final byte tceVersion;

        public ColumnEncryption(long length, byte tceVersion) {
            super((byte)4, length);
            this.tceVersion = tceVersion;
        }

        public static ColumnEncryption decode(ByteBuf buffer) {
            Assert.requireNonNull(buffer, "Buffer must not be null");
            long length = Decode.dword(buffer);
            if (length != 1L) {
                throw ProtocolException.unsupported("Unknown version number for AE");
            }
            byte tceVersion = buffer.readByte();
            if (tceVersion != 1) {
                throw ProtocolException.unsupported("Unsupported version number for AE");
            }
            return new ColumnEncryption(length, tceVersion);
        }

        public byte getTceVersion() {
            return this.tceVersion;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [tceVersion=").append(this.tceVersion);
            sb.append(']');
            return sb.toString();
        }
    }

    public static abstract class FeatureToken {
        private final byte featureId;
        private final long length;

        public FeatureToken(byte featureId, long length) {
            this.featureId = featureId;
            this.length = length;
        }
    }
}

