/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDoneToken;

public final class DoneProcToken
extends AbstractDoneToken {
    public static final byte TYPE = -2;
    private static final DoneProcToken[] INTERMEDIATE = new DoneProcToken[48];
    private static final DoneProcToken[] MORE_WITH_COUNT_CACHE = new DoneProcToken[48];
    private static final DoneProcToken[] DONE_WITH_COUNT_CACHE = new DoneProcToken[48];
    private static final DoneProcToken[] MORE_CACHE = new DoneProcToken[48];
    private static final int DONE_WITH_COUNT = 16;
    private static final int MORE_WITH_COUNT = 17;
    private static final int MORE = 1;

    private DoneProcToken(int status, int currentCommand, long rowCount) {
        super((byte)-2, status, currentCommand, rowCount);
    }

    public static DoneProcToken create(long rowCount) {
        return DoneProcToken.create0(16, 0, rowCount);
    }

    public static DoneProcToken decode(ByteBuf buffer) {
        int status = Decode.uShort(buffer);
        int currentCommand = Decode.uShort(buffer);
        long rowCount = Decode.uLongLong(buffer);
        return DoneProcToken.create0(status, currentCommand, rowCount);
    }

    private static DoneProcToken create0(int status, int currentCommand, long rowCount) {
        if (rowCount >= 0L && rowCount < 48L) {
            switch (status) {
                case 0: {
                    return INTERMEDIATE[(int)rowCount];
                }
                case 16: {
                    return DONE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 17: {
                    return MORE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 1: {
                    return MORE_CACHE[(int)rowCount];
                }
            }
        }
        return new DoneProcToken(status, currentCommand, rowCount);
    }

    @Override
    public String getName() {
        return "DONEPROC";
    }

    static {
        for (int i = 0; i < INTERMEDIATE.length; ++i) {
            DoneProcToken.INTERMEDIATE[i] = new DoneProcToken(0, 0, i);
            DoneProcToken.DONE_WITH_COUNT_CACHE[i] = new DoneProcToken(16, 0, i);
            DoneProcToken.MORE_WITH_COUNT_CACHE[i] = new DoneProcToken(17, 0, i);
            DoneProcToken.MORE_CACHE[i] = new DoneProcToken(1, 0, i);
        }
    }
}

