/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.CharacterEncoder;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.codec.StringCodec;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.R2dbcNonTransientException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ClobCodec
extends AbstractCodec<Clob> {
    public static final ClobCodec INSTANCE = new ClobCodec();
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.CHAR, new SqlServerType[]{SqlServerType.NCHAR, SqlServerType.VARCHAR, SqlServerType.NVARCHAR, SqlServerType.VARCHARMAX, SqlServerType.NVARCHARMAX, SqlServerType.TEXT, SqlServerType.NTEXT});

    private ClobCodec() {
        super(Clob.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Clob value) {
        return CharacterEncoder.encodePlp(allocator, context.getServerType(), context.getRequiredValueContext(RpcParameterContext.CharacterValueContext.class), value);
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return SUPPORTED_TYPES.contains((Object)serverType);
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return StringCodec.INSTANCE.doEncodeNull(allocator);
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return StringCodec.INSTANCE.encodeNull(allocator, serverType);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return SUPPORTED_TYPES.contains((Object)typeInformation.getServerType());
    }

    @Override
    @Nullable
    public Clob decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends Clob> type) {
        Length length;
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        if (decodable.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            PlpLength plpLength = buffer.isReadable() ? PlpLength.decode(buffer, decodable.getType()) : PlpLength.nullLength();
            length = Length.of(Math.toIntExact(plpLength.getLength()), plpLength.isNull());
        } else {
            length = Length.decode(buffer, decodable.getType());
        }
        if (length.isNull()) {
            return null;
        }
        return this.doDecode(buffer, length, decodable.getType(), type);
    }

    @Override
    Clob doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends Clob> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            int startIndex = buffer.readerIndex();
            while (buffer.isReadable()) {
                Length chunkLength = Length.decode(buffer, type);
                buffer.skipBytes(chunkLength.getLength());
            }
            int endIndex = buffer.readerIndex();
            buffer.readerIndex(startIndex);
            return new ScalarClob(type, length, buffer.readRetainedSlice(endIndex - startIndex));
        }
        return new ScalarClob(type, length, buffer.readRetainedSlice(length.getLength()));
    }

    static class ClobDecodeException
    extends R2dbcNonTransientException {
        public ClobDecodeException(String reason) {
            super(reason);
        }
    }

    static class ScalarClob
    implements Clob {
        private final TypeInformation type;
        private final Length valueLength;
        private final ByteBuf buffer;
        private final CompositeByteBuf remainder;

        ScalarClob(TypeInformation type, Length valueLength, ByteBuf buffer) {
            this.type = type;
            this.valueLength = valueLength;
            this.buffer = buffer.touch((Object)"ScalarClob");
            this.remainder = buffer.alloc().compositeBuffer();
        }

        public Publisher<CharSequence> stream() {
            CharsetDecoder decoder = this.type.getCharset().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            AtomicReference result = new AtomicReference();
            AtomicInteger counter = new AtomicInteger();
            return ScalarClob.createBufferStream(this.buffer, this.valueLength, this.type).handle((buffer, sink) -> {
                CoderResult decode;
                if (!buffer.isReadable()) {
                    buffer.release();
                    return;
                }
                this.remainder.addComponent(true, buffer);
                ByteBuffer byteBuffer = this.remainder.nioBuffer();
                int size = byteBuffer.remaining();
                CharBuffer outBuffer = CharBuffer.allocate(byteBuffer.remaining());
                CharsetDecoder charsetDecoder = decoder;
                synchronized (charsetDecoder) {
                    decode = decoder.decode(byteBuffer, outBuffer, false);
                }
                result.set(decode);
                int consumed = size - byteBuffer.remaining();
                if (consumed <= 0) {
                    sink.error((Throwable)new MalformedInputException(consumed));
                    return;
                }
                this.remainder.skipBytes(consumed);
                if (counter.incrementAndGet() % 16 == 0) {
                    this.remainder.discardSomeReadBytes();
                }
                outBuffer.flip();
                sink.next((Object)outBuffer.toString());
            }).doOnComplete(() -> {
                CoderResult coderResult = (CoderResult)result.get();
                if (coderResult != null && coderResult.isError()) {
                    if (coderResult.isMalformed()) {
                        throw new ClobDecodeException("Cannot decode CLOB data. Malformed character input");
                    }
                    if (coderResult.isUnmappable()) {
                        throw new ClobDecodeException("Cannot decode CLOB data. Unmappable characters");
                    }
                }
                if (this.remainder.isReadable()) {
                    throw new ClobDecodeException("Cannot decode CLOB data. Buffer has remainder: " + ByteBufUtil.hexDump((ByteBuf)this.remainder));
                }
            }).doFinally(s -> {
                if (this.remainder.refCnt() > 0) {
                    ReferenceCountUtil.safeRelease((Object)this.remainder);
                }
            });
        }

        public Publisher<Void> discard() {
            return Mono.fromRunnable(this::releaseBuffers);
        }

        private void releaseBuffers() {
            ReferenceCountUtil.safeRelease((Object)this.remainder);
            ReferenceCountUtil.safeRelease((Object)this.buffer);
        }

        private static Flux<ByteBuf> createBufferStream(ByteBuf plpStream, Length valueLength, TypeInformation type) {
            return Flux.generate(sink -> {
                try {
                    if (!plpStream.isReadable()) {
                        sink.complete();
                        return;
                    }
                    Length length = type.getLengthStrategy() == LengthStrategy.PARTLENTYPE ? Length.decode(plpStream, type) : valueLength;
                    sink.next((Object)plpStream.readRetainedSlice(length.getLength()));
                }
                catch (Exception e) {
                    sink.error((Throwable)e);
                }
            }).doFinally(s -> {
                if (plpStream.refCnt() > 0) {
                    ReferenceCountUtil.safeRelease((Object)plpStream);
                }
            });
        }
    }
}

