/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.BinaryCodec;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.PlpEncoded;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Blob;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class BlobCodec
extends AbstractCodec<Blob> {
    public static final BlobCodec INSTANCE = new BlobCodec();
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.BINARY, SqlServerType.VARBINARY, SqlServerType.VARBINARYMAX, SqlServerType.IMAGE);

    private BlobCodec() {
        super(Blob.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Blob value) {
        return new PlpEncoded(SqlServerType.VARBINARYMAX, allocator, (Publisher<ByteBuf>)Flux.from((Publisher)value.stream()).map(Unpooled::wrappedBuffer), () -> Mono.from((Publisher)value.discard()).toFuture());
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return SUPPORTED_TYPES.contains((Object)serverType);
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return BinaryCodec.INSTANCE.encodeNull(allocator);
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return BinaryCodec.INSTANCE.encodeNull(allocator, serverType);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return SUPPORTED_TYPES.contains((Object)typeInformation.getServerType());
    }

    @Override
    @Nullable
    public Blob decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends Blob> type) {
        Length length;
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        if (decodable.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            PlpLength plpLength = PlpLength.decode(buffer, decodable.getType());
            length = Length.of(Math.toIntExact(plpLength.getLength()), plpLength.isNull());
        } else {
            length = Length.decode(buffer, decodable.getType());
        }
        if (length.isNull()) {
            return null;
        }
        return this.doDecode(buffer, length, decodable.getType(), type);
    }

    @Override
    Blob doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends Blob> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            ArrayList<ByteBuf> chunks = new ArrayList<ByteBuf>();
            while (buffer.isReadable()) {
                Length chunkLength = Length.decode(buffer, type);
                chunks.add(buffer.readRetainedSlice(chunkLength.getLength()));
            }
            return new ScalarBlob(chunks);
        }
        return new ScalarBlob(Collections.singletonList(buffer.readRetainedSlice(length.getLength())));
    }

    static class ScalarBlob
    implements Blob {
        final List<ByteBuf> buffers;

        ScalarBlob(List<ByteBuf> buffers) {
            this.buffers = buffers;
            this.buffers.forEach(byteBuf -> byteBuf.touch((Object)"ScalarBlob"));
        }

        public Publisher<ByteBuffer> stream() {
            return Flux.fromIterable(this.buffers).map(it -> {
                if (!it.isReadable()) {
                    it.release();
                    return ByteBuffer.wrap(new byte[0]);
                }
                ByteBuffer result = ByteBuffer.allocate(it.readableBytes());
                it.readBytes(result);
                it.release();
                result.flip();
                return result;
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release).doOnCancel(() -> {
                for (ByteBuf buffer : this.buffers) {
                    if (buffer.refCnt() <= 0) continue;
                    buffer.release();
                }
            });
        }

        public Publisher<Void> discard() {
            return Mono.fromRunnable(() -> {
                for (ByteBuf buffer : this.buffers) {
                    if (buffer.refCnt() <= 0) continue;
                    buffer.release();
                }
            });
        }
    }
}

