/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.client.MessageDecoder;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.header.Header;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class StreamDecoder {
    private DecoderState state;

    StreamDecoder() {
    }

    public List<Message> decode(ByteBuf in, MessageDecoder messageDecoder) {
        Assert.requireNonNull(in, "in must not be null");
        Assert.requireNonNull(messageDecoder, "MessageDecoder must not be null");
        ListSink<Message> result = new ListSink<Message>();
        this.decode(in, messageDecoder, result);
        return result;
    }

    public void decode(ByteBuf in, MessageDecoder messageDecoder, SynchronousSink<Message> sink) {
        DecoderState state;
        Assert.requireNonNull(in, "in must not be null");
        Assert.requireNonNull(messageDecoder, "MessageDecoder must not be null");
        DecoderState decoderState = this.state;
        this.state = null;
        DecoderState decoderState2 = state = decoderState == null ? DecoderState.initial(in) : decoderState.andChunk(in);
        while ((state = this.withState(messageDecoder, sink, state)) != null) {
        }
    }

    @Nullable
    private DecoderState withState(MessageDecoder messageDecoder, SynchronousSink<Message> sink, DecoderState state) {
        if (state.header == null) {
            if (!Header.canDecode(state.remainder)) {
                return this.retain(state);
            }
            state = state.readHeader();
        }
        try {
            Header header = state.getRequiredHeader();
            if (!state.canReadChunk()) {
                return this.retain(state);
            }
            state = state.readChunk();
            int readerIndex = state.aggregatedBodyReaderIndex();
            boolean hasMessages = messageDecoder.decode(header, state.aggregatedBody, sink);
            if (hasMessages) {
                if (state.hasRawRemainder()) {
                    return state;
                }
                if (state.hasAggregatedBodyRemainder()) {
                    return this.retain(state);
                }
            } else {
                state.aggregatedBodyReaderIndex(readerIndex);
                return this.retain(state);
            }
            state.release();
            return null;
        }
        catch (Exception e) {
            sink.error((Throwable)e);
            return state;
        }
    }

    @Nullable
    private DecoderState retain(DecoderState state) {
        this.state = state;
        return null;
    }

    @Nullable
    DecoderState getDecoderState() {
        return this.state;
    }

    static class ListSink<T>
    extends ArrayList<T>
    implements SynchronousSink<T> {
        public ListSink() {
            super(2);
        }

        public void complete() {
            throw new UnsupportedOperationException();
        }

        public Context currentContext() {
            throw new UnsupportedOperationException();
        }

        public void error(Throwable e) {
            throw new RuntimeException(e);
        }

        public void next(T message) {
            this.add(message);
        }
    }

    static class DecoderState {
        ByteBuf remainder;
        ByteBuf aggregatedBody;
        @Nullable
        Header header;

        private DecoderState(ByteBuf remainder, ByteBuf aggregatedBody, @Nullable Header header) {
            this.remainder = remainder;
            this.header = header;
            this.aggregatedBody = aggregatedBody;
        }

        static DecoderState initial(ByteBuf initialBuffer) {
            ByteBuf composite = initialBuffer.alloc().buffer();
            composite.writeBytes(initialBuffer);
            ByteBuf aggregatedBody = initialBuffer.alloc().buffer();
            return new DecoderState(composite, aggregatedBody, null);
        }

        DecoderState andChunk(ByteBuf in) {
            this.remainder.writeBytes(in);
            return this.newState(this.remainder, this.aggregatedBody, this.header);
        }

        DecoderState newState(ByteBuf remainder, ByteBuf aggregatedBody, @Nullable Header header) {
            this.remainder = remainder;
            this.aggregatedBody = aggregatedBody;
            this.header = header;
            return this;
        }

        boolean canReadChunk() {
            int requiredChunkLength = this.getChunkLength();
            return this.remainder.readableBytes() >= requiredChunkLength;
        }

        boolean hasRawRemainder() {
            return this.remainder.readableBytes() != 0;
        }

        boolean hasAggregatedBodyRemainder() {
            return this.aggregatedBody.readableBytes() != 0;
        }

        int aggregatedBodyReaderIndex() {
            return this.aggregatedBody.readerIndex();
        }

        void aggregatedBodyReaderIndex(int index) {
            this.aggregatedBody.readerIndex(index);
        }

        Header getRequiredHeader() {
            if (this.header == null) {
                throw new IllegalStateException("DecoderState has no header");
            }
            return this.header;
        }

        DecoderState readHeader() {
            return this.newState(this.remainder, this.aggregatedBody, Header.decode(this.remainder));
        }

        DecoderState readChunk() {
            boolean hasNewHeader;
            do {
                hasNewHeader = false;
                this.aggregatedBody.writeBytes(this.remainder, this.getChunkLength());
                if (!Header.canDecode(this.remainder)) continue;
                hasNewHeader = true;
                this.header = Header.decode(this.remainder);
            } while (this.canReadChunk());
            if (hasNewHeader) {
                return this.newState(this.remainder, this.aggregatedBody, this.header);
            }
            return this.newState(this.remainder, this.aggregatedBody, null);
        }

        DecoderState retain() {
            this.remainder.retain();
            this.aggregatedBody.retain();
            return this;
        }

        void release() {
            this.remainder.release();
            this.aggregatedBody.release();
        }

        int getChunkLength() {
            return this.getRequiredHeader().getLength() - 8;
        }
    }
}

