/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import java.util.Arrays;
import org.h2.value.Value;
import org.h2.value.ValueArray;

final class ArrayCodec
extends AbstractCodec<Object[]> {
    private final Codecs codecs;

    ArrayCodec(Codecs codecs) {
        super(Object[].class);
        this.codecs = codecs;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 40;
    }

    @Override
    Object[] doDecode(Value value, Class<? extends Object[]> type) {
        ValueArray valueArray = (ValueArray)value.convertTo(40);
        return Arrays.stream(valueArray.getList()).map(val -> this.codecs.decode((Value)val, val.getValueType(), Object.class)).toArray();
    }

    @Override
    Value doEncode(Object[] value) {
        return ValueArray.get((Value[])((Value[])Arrays.stream(Assert.requireNonNull(value, "value must not be null")).map(this.codecs::encode).toArray(Value[]::new)), null);
    }
}

